/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.sink.connector;

import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mq.rocketmq.RocketMQSinkConfig;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQSinkConnector
implements Sink,
ConnectorCreateService<Sink> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocketMQSinkConnector.class);
    private RocketMQSinkConfig sinkConfig;
    private final DefaultMQProducer producer = new DefaultMQProducer();

    public Class<? extends Config> configClass() {
        return RocketMQSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (RocketMQSinkConfig)config;
        this.producer.setProducerGroup(this.sinkConfig.getPubSubConfig().getGroup());
        this.producer.setNamesrvAddr(this.sinkConfig.getConnectorConfig().getNameServer());
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (RocketMQSinkConfig)sinkConnectorContext.getSinkConfig();
        this.producer.setProducerGroup(this.sinkConfig.getPubSubConfig().getGroup());
        this.producer.setNamesrvAddr(this.sinkConfig.getConnectorConfig().getNameServer());
    }

    public void start() throws Exception {
        this.producer.start();
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        this.producer.shutdown();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            Message message = this.convertRecordToMessage(connectRecord);
            try {
                SendResult sendResult = this.producer.send(message);
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[RocketMQSinkConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
            catch (Exception e) {
                log.error("[RocketMQSinkConnector] sendResult has error : ", (Throwable)e);
            }
        }
    }

    public Message convertRecordToMessage(ConnectRecord connectRecord) {
        Message message = new Message();
        message.setTopic(this.sinkConfig.getConnectorConfig().getTopic());
        message.setBody((byte[])connectRecord.getData());
        for (String key : connectRecord.getExtensions().keySet()) {
            MessageAccessor.putProperty((Message)message, (String)key, (String)connectRecord.getExtension(key));
        }
        return message;
    }

    public Sink create() {
        return new RocketMQSinkConnector();
    }
}

