/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.source;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mcp.McpSourceConfig;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.mcp.source.McpToolRegistry;
import org.apache.eventmesh.connector.mcp.source.protocol.Protocol;
import org.apache.eventmesh.connector.mcp.source.protocol.ProtocolFactory;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpSourceConnector
implements Source,
ConnectorCreateService<Source> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpSourceConnector.class);
    private McpSourceConfig sourceConfig;
    private BlockingQueue<Object> queue;
    private int batchSize;
    private String forwardPath;
    private Route route;
    private Protocol protocol;
    private HttpServer server;
    private Vertx vertx;
    private WebClient webClient;
    private McpToolRegistry toolRegistry;
    private volatile boolean started = false;
    private volatile boolean destroyed = false;

    public Class<? extends Config> configClass() {
        return McpSourceConfig.class;
    }

    public Source create() {
        return new McpSourceConnector();
    }

    public void init(Config config) {
        this.sourceConfig = (McpSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (McpSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        log.info("Initializing MCP Source Connector...");
        int maxQueueSize = this.sourceConfig.getConnectorConfig().getMaxStorageSize();
        this.queue = new LinkedBlockingQueue<Object>(maxQueueSize);
        this.batchSize = this.sourceConfig.getConnectorConfig().getBatchSize();
        String protocolName = this.sourceConfig.getConnectorConfig().getProtocol();
        this.protocol = ProtocolFactory.getInstance(this.sourceConfig.connectorConfig, protocolName);
        this.toolRegistry = new McpToolRegistry();
        this.registerDefaultTools();
        this.vertx = Vertx.vertx();
        Router router = Router.router((Vertx)this.vertx);
        this.webClient = WebClient.create((Vertx)this.vertx);
        String basePath = this.sourceConfig.connectorConfig.getPath();
        this.forwardPath = this.sourceConfig.connectorConfig.getForwardPath();
        router.route().handler(ctx -> {
            ctx.response().putHeader("Access-Control-Allow-Origin", "*").putHeader("Access-Control-Allow-Methods", "GET, POST, OPTIONS").putHeader("Access-Control-Allow-Headers", "Content-Type, Authorization, Accept").putHeader("Access-Control-Expose-Headers", "Content-Type");
            if ("OPTIONS".equals(ctx.request().method().name())) {
                ctx.response().setStatusCode(204).end();
            } else {
                ctx.next();
            }
        });
        router.route().handler((Handler)BodyHandler.create());
        router.post(basePath).handler((Handler)LoggerHandler.create()).handler(ctx -> {
            String contentType = ctx.request().getHeader("Content-Type");
            String accept = ctx.request().getHeader("Accept");
            if ("text/event-stream; charset=utf-8".startsWith(accept != null ? accept : "")) {
                this.handleSseRequest((RoutingContext)ctx);
            } else {
                this.handleJsonRpcRequest((RoutingContext)ctx);
            }
        });
        router.get(basePath).handler(this::handleSseRequest);
        router.get(basePath + "/health").handler(ctx -> {
            JsonObject health = new JsonObject().put("status", (Object)"UP").put("connector", (Object)"mcp-source").put("tools", (Object)this.toolRegistry.getToolCount());
            ctx.response().putHeader("Content-Type", "application/json; charset=utf-8").end(health.encode());
        });
        Route forwardRoute = router.route().path(this.forwardPath).handler((Handler)LoggerHandler.create());
        this.route = router.route().path(this.sourceConfig.connectorConfig.getPath()).handler((Handler)LoggerHandler.create());
        this.protocol.setHandler(this.route, this.queue);
        this.protocol.setHandler(forwardRoute, this.queue);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(this.sourceConfig.connectorConfig.getPort()).setHandle100ContinueAutomatically(true).setIdleTimeout(60000).setIdleTimeoutUnit(TimeUnit.MILLISECONDS)).requestHandler((Handler)router);
        log.info("MCP Source Connector initialized on http://127.0.0.1:{}{}", (Object)this.sourceConfig.connectorConfig.getPort(), (Object)basePath);
    }

    private void registerDefaultTools() {
        this.toolRegistry.registerTool("echo", "Echo back the input message", this.createEchoSchema(), args -> {
            String message = args.getString("message", "No message");
            return this.createTextContent("Echo: " + message);
        });
        this.toolRegistry.registerTool("sendEventMeshMessage", "Send a message to EventMesh", this.createSendMessageSchema(), args -> {
            String topic = args.getString("topic");
            String message = args.getString("message");
            this.webClient.post(this.sourceConfig.connectorConfig.getPort(), "127.0.0.1", this.forwardPath).putHeader("Content-Type", "application/json").sendBuffer(Buffer.buffer((String)new JsonObject().put("type", (Object)"mcp.tools.call").put("tool", (Object)"sendEventMeshMessage").put("arguments", (Object)new JsonObject().put("message", (Object)message).put("topic", (Object)topic)).encode()), ar -> {
                if (ar.succeeded()) {
                    log.info("forwarded tools/call to {} OK, status={}", (Object)this.forwardPath, (Object)((HttpResponse)ar.result()).statusCode());
                } else {
                    log.warn("forward tools/call failed: {}", (Object)ar.cause().toString());
                }
            });
            return this.createTextContent(String.format("Message sent to topic '%s': %s", topic, message));
        });
        log.info("Registered {} MCP tools", (Object)this.toolRegistry.getToolCount());
    }

    private void handleJsonRpcRequest(RoutingContext ctx) {
        String body = ctx.body().asString();
        try {
            JsonObject request = new JsonObject(body);
            JsonObject response = this.handleMcpRequest(request);
            if (response != null) {
                ctx.response().putHeader("Content-Type", "application/json; charset=utf-8").end(response.encode());
            } else {
                ctx.response().setStatusCode(204).end();
            }
        }
        catch (Exception e) {
            JsonObject error = this.createErrorResponse(null, -32603, "Internal error: " + e.getMessage());
            ctx.response().putHeader("Content-Type", "application/json; charset=utf-8").setStatusCode(500).end(error.encode());
        }
    }

    private void handleSseRequest(RoutingContext ctx) {
        ctx.response().putHeader("Content-Type", "text/event-stream; charset=utf-8").putHeader("Cache-Control", "no-cache").putHeader("Connection", "keep-alive").putHeader("X-Accel-Buffering", "no").setChunked(true);
        ctx.response().write("event: open\n");
        ctx.response().write("data: {\"type\":\"open\"}\n\n");
        long timerId = this.vertx.setPeriodic(30000L, id -> {
            if (!ctx.response().closed()) {
                ctx.response().write(": heartbeat\n\n");
            } else {
                this.vertx.cancelTimer(id.longValue());
            }
        });
        ctx.request().connection().closeHandler(v -> this.vertx.cancelTimer(timerId));
    }

    private JsonObject handleMcpRequest(JsonObject request) {
        String method = request.getString("method", "");
        Object id = request.getValue("id");
        JsonObject params = request.getJsonObject("params");
        switch (method) {
            case "initialize": {
                return this.handleInitialize(id, params);
            }
            case "notifications/initialized": {
                return null;
            }
            case "tools/list": {
                return this.handleToolsList(id);
            }
            case "tools/call": {
                return this.handleToolsCall(id, params);
            }
            case "ping": {
                return this.createSuccessResponse(id, new JsonObject());
            }
        }
        return this.createErrorResponse(id, -32601, "Method not found: " + method);
    }

    private JsonObject handleInitialize(Object id, JsonObject params) {
        String clientVersion = params != null ? params.getString("protocolVersion", "2024-11-05") : "2024-11-05";
        JsonObject result = new JsonObject().put("protocolVersion", (Object)clientVersion).put("serverInfo", (Object)new JsonObject().put("name", (Object)"eventmesh-mcp-connector").put("version", (Object)"1.0.0")).put("capabilities", (Object)new JsonObject().put("tools", (Object)new JsonObject()));
        return this.createSuccessResponse(id, result);
    }

    private JsonObject handleToolsList(Object id) {
        JsonArray tools = this.toolRegistry.getToolsArray();
        JsonObject result = new JsonObject().put("tools", (Object)tools);
        return this.createSuccessResponse(id, result);
    }

    private JsonObject handleToolsCall(Object id, JsonObject params) {
        if (params == null) {
            return this.createErrorResponse(id, -32602, "Invalid params");
        }
        String toolName = params.getString("name");
        JsonObject arguments = params.getJsonObject("arguments", new JsonObject());
        log.info("Calling tool: {} with arguments: {}", (Object)toolName, (Object)arguments);
        try {
            JsonObject content = this.toolRegistry.executeTool(toolName, arguments);
            JsonObject result = new JsonObject().put("content", (Object)new JsonArray().add((Object)content));
            return this.createSuccessResponse(id, result);
        }
        catch (IllegalArgumentException e) {
            return this.createErrorResponse(id, -32602, e.getMessage());
        }
        catch (Exception e) {
            log.error("Tool execution error", (Throwable)e);
            return this.createErrorResponse(id, -32603, "Tool execution failed: " + e.getMessage());
        }
    }

    private JsonObject createSuccessResponse(Object id, JsonObject result) {
        return new JsonObject().put("jsonrpc", (Object)"2.0").put("id", id).put("result", (Object)result);
    }

    private JsonObject createErrorResponse(Object id, int code, String message) {
        return new JsonObject().put("jsonrpc", (Object)"2.0").put("id", id).put("error", (Object)new JsonObject().put("code", (Object)code).put("message", (Object)message));
    }

    private JsonObject createEchoSchema() {
        return new JsonObject().put("type", (Object)"object").put("properties", (Object)new JsonObject().put("message", (Object)new JsonObject().put("type", (Object)"string").put("description", (Object)"Message to echo"))).put("required", (Object)new JsonArray().add((Object)"message"));
    }

    private JsonObject createSendMessageSchema() {
        return new JsonObject().put("type", (Object)"object").put("properties", (Object)new JsonObject().put("topic", (Object)new JsonObject().put("type", (Object)"string").put("description", (Object)"EventMesh topic")).put("message", (Object)new JsonObject().put("type", (Object)"string").put("description", (Object)"Message content"))).put("required", (Object)new JsonArray().add((Object)"topic").add((Object)"message"));
    }

    private JsonObject createTextContent(String text) {
        return new JsonObject().put("type", (Object)"text").put("text", (Object)text);
    }

    public void start() {
        this.server.listen(res -> {
            if (!res.succeeded()) {
                log.error("McpSourceConnector failed to start on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
                throw new EventMeshException("failed to start Vertx server", res.cause());
            }
            this.started = true;
            log.info("McpSourceConnector started on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
            log.info("MCP endpoints available at:");
            log.info("  - POST {} (JSON-RPC)", (Object)this.sourceConfig.connectorConfig.getPath());
            log.info("  - GET {} (SSE)", (Object)this.sourceConfig.connectorConfig.getPath());
            log.info("  - GET {}{} (Health check)", (Object)this.sourceConfig.connectorConfig.getPath(), (Object)"/health");
        });
    }

    public void commit(ConnectRecord record) {
        if (this.sourceConfig.getConnectorConfig().isDataConsistencyEnabled()) {
            log.debug("McpSourceConnector commit record: {}", (Object)record.getRecordId());
        }
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
        log.error("Exception occurred for record: {}", (Object)record.getRecordId());
    }

    public void stop() {
        if (this.server != null) {
            this.server.close(res -> {
                if (!res.succeeded()) {
                    log.error("McpSourceConnector failed to stop on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
                    throw new EventMeshException("failed to stop Vertx server", res.cause());
                }
                this.destroyed = true;
                log.info("McpSourceConnector stopped on port: {}", (Object)this.sourceConfig.getConnectorConfig().getPort());
            });
        } else {
            log.warn("McpSourceConnector server is null, ignore.");
        }
        if (this.vertx != null) {
            this.vertx.close();
        }
    }

    public List<ConnectRecord> poll() {
        long startTime = System.currentTimeMillis();
        long remainingTime = 5000L;
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(this.batchSize);
        for (int i = 0; i < this.batchSize; ++i) {
            try {
                Object obj = this.queue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (obj == null) break;
                ConnectRecord connectRecord = this.protocol.convertToConnectRecord(obj);
                connectRecords.add(connectRecord);
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = 5000L > elapsedTime ? 5000L - elapsedTime : 0L;
                continue;
            }
            catch (Exception e) {
                log.error("Failed to poll from queue.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return connectRecords;
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Generated
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

