/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.source.connector;

import com.google.common.util.concurrent.RateLimiter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.eventmesh.common.AbstractComponent;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.JdbcConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSourceCheckConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.JobRdbFullPosition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbDBDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbTableDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.mysql.MySQLTableDef;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.canal.DatabaseConnection;
import org.apache.eventmesh.connector.canal.source.connector.CanalFullProducer;
import org.apache.eventmesh.connector.canal.source.position.CanalCheckPositionMgr;
import org.apache.eventmesh.connector.canal.source.table.RdbSimpleTable;
import org.apache.eventmesh.connector.canal.source.table.RdbTableMgr;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalSourceCheckConnector
extends AbstractComponent
implements Source,
ConnectorCreateService<Source> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalSourceCheckConnector.class);
    private CanalSourceCheckConfig config;
    private CanalCheckPositionMgr positionMgr;
    private RdbTableMgr tableMgr;
    private ThreadPoolExecutor executor;
    private final ScheduledExecutorService scheduledThreadPoolExecutor = Executors.newSingleThreadScheduledExecutor();
    private final BlockingQueue<List<ConnectRecord>> queue = new LinkedBlockingQueue<List<ConnectRecord>>(10000);
    private final AtomicBoolean flag = new AtomicBoolean(true);
    private RateLimiter globalLimiter;

    protected void run() throws Exception {
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
            try {
                this.tableMgr.start();
            }
            catch (Exception e) {
                log.error("start tableMgr fail", (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                this.positionMgr.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.executor = new ThreadPoolExecutor(this.config.getParallel(), this.config.getParallel(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new EventMeshThreadFactory("canal-source-check"));
            LinkedList<CanalFullProducer> producers = new LinkedList<CanalFullProducer>();
            if (this.config.getSourceConnectorConfig().getDatabases() != null) {
                for (RdbDBDefinition db : this.config.getSourceConnectorConfig().getDatabases()) {
                    for (RdbTableDefinition table : db.getTables()) {
                        try {
                            log.info("it will create producer of db [{}] table [{}]", (Object)db.getSchemaName(), (Object)table.getTableName());
                            RdbSimpleTable simpleTable = new RdbSimpleTable(db.getSchemaName(), table.getTableName());
                            JobRdbFullPosition position = this.positionMgr.getPosition(simpleTable);
                            if (position == null) {
                                throw new EventMeshException(String.format("db [%s] table [%s] have none position info", db.getSchemaName(), table.getTableName()));
                            }
                            RdbTableDefinition tableDefinition = this.tableMgr.getTable(simpleTable);
                            if (tableDefinition == null) {
                                throw new EventMeshException(String.format("db [%s] table [%s] have none table definition info", db.getSchemaName(), table.getTableName()));
                            }
                            CanalFullProducer producer = new CanalFullProducer(this.queue, (DataSource)DatabaseConnection.sourceDataSource, (MySQLTableDef)tableDefinition, position, this.config.getFlushSize(), this.config.getPagePerSecond());
                            producer.setRecordLimiter(this.globalLimiter);
                            producers.add(producer);
                        }
                        catch (Exception e) {
                            log.error("create schema [{}] table [{}] producers fail", new Object[]{db.getSchemaName(), table.getTableName(), e});
                        }
                    }
                }
            }
            producers.forEach(p -> this.executor.execute(() -> p.start(this.flag)));
        }, 0L, this.config.getExecutePeriod(), TimeUnit.SECONDS);
    }

    protected void shutdown() throws Exception {
        this.flag.set(false);
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warn("wait thread pool shutdown timeout, it will shutdown now");
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("shutdown thread pool fail");
            }
        }
        if (!this.scheduledThreadPoolExecutor.isShutdown()) {
            this.scheduledThreadPoolExecutor.shutdown();
            try {
                if (!this.scheduledThreadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warn("wait scheduledThreadPoolExecutor shutdown timeout, it will shutdown now");
                    this.scheduledThreadPoolExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("shutdown scheduledThreadPoolExecutor fail");
            }
        }
        if (DatabaseConnection.sourceDataSource != null) {
            DatabaseConnection.sourceDataSource.close();
            log.info("data source has been closed");
        }
    }

    public Source create() {
        return new CanalSourceCheckConnector();
    }

    public Class<? extends Config> configClass() {
        return CanalSourceCheckConfig.class;
    }

    public void init(Config config) throws Exception {
        this.config = (CanalSourceCheckConfig)config;
        this.init();
    }

    private void init() {
        DatabaseConnection.sourceConfig = this.config.getSourceConnectorConfig();
        DatabaseConnection.initSourceConnection();
        this.tableMgr = new RdbTableMgr((JdbcConfig)this.config.getSourceConnectorConfig(), (DataSource)DatabaseConnection.sourceDataSource);
        this.positionMgr = new CanalCheckPositionMgr(this.config, this.tableMgr);
        this.globalLimiter = RateLimiter.create((double)this.config.getRecordPerSecond().intValue());
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        CanalSourceConfig canalSourceConfig = (CanalSourceConfig)sourceConnectorContext.getSourceConfig();
        this.config = (CanalSourceCheckConfig)ConfigUtil.parse((Map)canalSourceConfig.getSourceConfig(), CanalSourceCheckConfig.class);
        this.init();
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.config.getSourceConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public List<ConnectRecord> poll() {
        while (this.flag.get()) {
            try {
                List<ConnectRecord> records = this.queue.poll(5L, TimeUnit.SECONDS);
                if (records == null || records.isEmpty()) continue;
                return records;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                log.info("[{}] thread interrupted", ((Object)((Object)this)).getClass());
                return null;
            }
        }
        log.info("[{}] life flag is stop, so return null", ((Object)((Object)this)).getClass());
        return null;
    }
}

