/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.sink;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;
import org.apache.eventmesh.connector.canal.model.EventColumn;
import org.apache.eventmesh.connector.canal.model.EventColumnIndexComparable;
import org.apache.eventmesh.connector.canal.model.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DbLoadMerger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbLoadMerger.class);

    public static List<CanalConnectRecord> merge(List<CanalConnectRecord> eventDatas) {
        LinkedHashMap<RowKey, CanalConnectRecord> result = new LinkedHashMap<RowKey, CanalConnectRecord>();
        for (CanalConnectRecord eventData : eventDatas) {
            DbLoadMerger.merge(eventData, result);
        }
        return new LinkedList<CanalConnectRecord>(result.values());
    }

    public static void merge(CanalConnectRecord record, Map<RowKey, CanalConnectRecord> result) {
        EventType eventType = record.getEventType();
        switch (eventType) {
            case INSERT: {
                DbLoadMerger.mergeInsert(record, result);
                break;
            }
            case UPDATE: {
                DbLoadMerger.mergeUpdate(record, result);
                break;
            }
            case DELETE: {
                DbLoadMerger.mergeDelete(record, result);
                break;
            }
        }
    }

    private static void mergeInsert(CanalConnectRecord record, Map<RowKey, CanalConnectRecord> result) {
        RowKey rowKey = new RowKey(record.getSchemaName(), record.getTableName(), record.getKeys());
        if (!result.containsKey(rowKey)) {
            result.put(rowKey, record);
        } else {
            CanalConnectRecord oldRecord = result.get(rowKey);
            record.setSize(oldRecord.getSize() + record.getSize());
            if (oldRecord.getEventType() == EventType.DELETE) {
                result.put(rowKey, record);
            } else if (record.getEventType() == EventType.UPDATE || record.getEventType() == EventType.INSERT) {
                log.warn("update-insert/insert-insert happend. before[{}] , after[{}]", (Object)oldRecord, (Object)record);
                CanalConnectRecord mergeEventData = DbLoadMerger.replaceColumnValue(record, oldRecord);
                mergeEventData.getOldKeys().clear();
                result.put(rowKey, mergeEventData);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mergeUpdate(CanalConnectRecord record, Map<RowKey, CanalConnectRecord> result) {
        RowKey rowKey = new RowKey(record.getSchemaName(), record.getTableName(), record.getKeys());
        if (!CollectionUtils.isEmpty(record.getOldKeys())) {
            RowKey oldKey = new RowKey(record.getSchemaName(), record.getTableName(), record.getOldKeys());
            if (!result.containsKey(oldKey)) {
                result.put(rowKey, record);
                return;
            } else {
                CanalConnectRecord oldRecord = result.get(oldKey);
                record.setSize(oldRecord.getSize() + record.getSize());
                if (oldRecord.getEventType() == EventType.INSERT) {
                    record.setEventType(EventType.INSERT);
                    result.remove(oldKey);
                    CanalConnectRecord mergeEventData = DbLoadMerger.replaceColumnValue(record, oldRecord);
                    mergeEventData.getOldKeys().clear();
                    result.put(rowKey, mergeEventData);
                    return;
                } else {
                    if (oldRecord.getEventType() != EventType.UPDATE) throw new RuntimeException("delete(has old pks) + update impossible happed!");
                    result.remove(oldKey);
                    CanalConnectRecord mergeEventData = DbLoadMerger.replaceColumnValue(record, oldRecord);
                    result.put(rowKey, mergeEventData);
                }
            }
            return;
        } else if (!result.containsKey(rowKey)) {
            result.put(rowKey, record);
            return;
        } else {
            CanalConnectRecord oldRecord = result.get(rowKey);
            if (oldRecord.getEventType() == EventType.INSERT) {
                oldRecord.setEventType(EventType.INSERT);
                CanalConnectRecord mergeEventData = DbLoadMerger.replaceColumnValue(record, oldRecord);
                result.put(rowKey, mergeEventData);
                return;
            } else if (oldRecord.getEventType() == EventType.UPDATE) {
                CanalConnectRecord mergeEventData = DbLoadMerger.replaceColumnValue(record, oldRecord);
                result.put(rowKey, mergeEventData);
                return;
            } else {
                if (oldRecord.getEventType() != EventType.DELETE) return;
                result.put(rowKey, record);
            }
        }
    }

    private static void mergeDelete(CanalConnectRecord record, Map<RowKey, CanalConnectRecord> result) {
        RowKey rowKey = new RowKey(record.getSchemaName(), record.getTableName(), record.getKeys());
        if (!result.containsKey(rowKey)) {
            result.put(rowKey, record);
        } else {
            CanalConnectRecord oldRecord = result.get(rowKey);
            record.setSize(oldRecord.getSize() + record.getSize());
            if (!CollectionUtils.isEmpty(oldRecord.getOldKeys())) {
                record.setKeys(oldRecord.getOldKeys());
                record.getOldKeys().clear();
                result.remove(rowKey);
                result.put(new RowKey(record.getSchemaName(), record.getTableName(), record.getKeys()), record);
            } else {
                record.getOldKeys().clear();
                result.put(rowKey, record);
            }
        }
    }

    private static CanalConnectRecord replaceColumnValue(CanalConnectRecord newRecord, CanalConnectRecord oldRecord) {
        List<EventColumn> newColumns = newRecord.getColumns();
        List<EventColumn> oldColumns = oldRecord.getColumns();
        ArrayList<EventColumn> temp = new ArrayList<EventColumn>();
        for (EventColumn oldColumn : oldColumns) {
            boolean contain = false;
            for (EventColumn newColumn : newColumns) {
                if (!oldColumn.getColumnName().equalsIgnoreCase(newColumn.getColumnName())) continue;
                newColumn.setUpdate(newColumn.isUpdate() || oldColumn.isUpdate());
                contain = true;
            }
            if (contain) continue;
            temp.add(oldColumn);
        }
        newColumns.addAll(temp);
        Collections.sort(newColumns, new EventColumnIndexComparable());
        newRecord.setOldKeys(oldRecord.getOldKeys());
        if (oldRecord.getSyncConsistency() != null) {
            newRecord.setSyncConsistency(oldRecord.getSyncConsistency());
        }
        if (oldRecord.getSyncMode() != null) {
            newRecord.setSyncMode(oldRecord.getSyncMode());
        }
        if (oldRecord.isRemedy()) {
            newRecord.setRemedy(true);
        }
        newRecord.setSize(oldRecord.getSize() + newRecord.getSize());
        return newRecord;
    }

    public static class RowKey
    implements Serializable {
        private String schemaName;
        private String tableName;
        private List<EventColumn> keys = new ArrayList<EventColumn>();

        public RowKey(String schemaName, String tableName, List<EventColumn> keys) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.keys = keys;
        }

        public RowKey(List<EventColumn> keys) {
            this.keys = keys;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
            result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
            result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RowKey)) {
                return false;
            }
            RowKey other = (RowKey)obj;
            if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
                return false;
            }
            if (this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName)) {
                return false;
            }
            if (this.tableName == null) {
                return other.tableName == null;
            }
            return this.tableName.equals(other.tableName);
        }

        @Generated
        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Generated
        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Generated
        public void setKeys(List<EventColumn> keys) {
            this.keys = keys;
        }

        @Generated
        public String getSchemaName() {
            return this.schemaName;
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public List<EventColumn> getKeys() {
            return this.keys;
        }
    }
}

