/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.util.argument;

import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.util.argument.ArgumentValidator;
import com.navercorp.pinpoint.bootstrap.util.argument.ClassPredicate;
import com.navercorp.pinpoint.bootstrap.util.argument.Predicate;
import com.navercorp.pinpoint.bootstrap.util.argument.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Validation {
    private final PluginLogger logger;
    private final List<Predicate> list = new ArrayList<Predicate>(4);
    private int min;

    public Validation(PluginLogger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    public Validation addArgument(Class<?> clazz, int index) {
        this.list.add(new ClassPredicate(this.logger, clazz, index));
        return this;
    }

    public Validation addPredicate(Predicate predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.list.add(predicate);
        return this;
    }

    public Validation minArgsSize(int min) {
        this.min = min;
        return this;
    }

    public Validator build() {
        ArrayList<Predicate> list = new ArrayList<Predicate>(this.list);
        return new ArgumentValidator(list, this.min);
    }
}

