/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Objects;

public class HttpParameterRecorder<T>
implements ParameterRecorder<T> {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final ParameterExtractor<T> parameterExtractor;

    public HttpParameterRecorder(ParameterExtractor<T> parameterExtractor) {
        this.parameterExtractor = Objects.requireNonNull(parameterExtractor, "parameterExtractor");
    }

    @Override
    public void record(SpanEventRecorder spanRecorder, T request, Throwable throwable) {
        String parameters = this.parameterExtractor.extractParameter(request);
        if (StringUtils.hasLength((String)parameters)) {
            spanRecorder.recordAttribute(AnnotationKey.HTTP_PARAM, parameters);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Record httpParam={}", (Object)parameters);
            }
        }
    }
}

