/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.tables.KeyValueTableClientConfiguration;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentFactory;
import io.pravega.client.tables.impl.TableSegmentImpl;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

class TableSegmentFactoryImpl
implements TableSegmentFactory {
    @NonNull
    private final Controller controller;
    @NonNull
    private final ConnectionPool connectionPool;
    @NonNull
    private final KeyValueTableClientConfiguration clientConfig;
    private final DelegationTokenProvider tokenProvider;

    @Override
    public TableSegment forSegment(@NonNull Segment segment) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        return new TableSegmentImpl(segment, this.controller, this.connectionPool, this.clientConfig, this.tokenProvider);
    }

    @ConstructorProperties(value={"controller", "connectionPool", "clientConfig", "tokenProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableSegmentFactoryImpl(@NonNull Controller controller, @NonNull ConnectionPool connectionPool, @NonNull KeyValueTableClientConfiguration clientConfig, DelegationTokenProvider tokenProvider) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (connectionPool == null) {
            throw new NullPointerException("connectionPool is marked non-null but is null");
        }
        if (clientConfig == null) {
            throw new NullPointerException("clientConfig is marked non-null but is null");
        }
        this.controller = controller;
        this.connectionPool = connectionPool;
        this.clientConfig = clientConfig;
        this.tokenProvider = tokenProvider;
    }
}

