/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.file.source.connector;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.file.FileSourceConfig;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.file.FileRecordPartition;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSourceConnector
implements Source {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSourceConnector.class);
    private static final int BUFFER_SIZE = 8192;
    private FileSourceConfig sourceConfig;
    private String filePath;
    private String fileName;
    private BufferedReader bufferedReader;

    public Class<? extends Config> configClass() {
        return FileSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (FileSourceConfig)config;
        this.filePath = ((FileSourceConfig)config).getConnectorConfig().getFilePath();
        this.fileName = FileSourceConnector.getFileName(this.filePath);
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (FileSourceConfig)sourceConnectorContext.getSourceConfig();
    }

    public void start() throws Exception {
        if (this.filePath == null || this.filePath.isEmpty()) {
            this.bufferedReader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        } else {
            Path path = Paths.get(this.filePath, new String[0]);
            this.bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8), 8192);
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        try {
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
        }
        catch (Exception e) {
            log.error("Error closing resources: {}", (Object)e.getMessage());
        }
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>();
        RecordPartition recordPartition = FileSourceConnector.convertToRecordPartition(this.fileName);
        try {
            int bytesRead;
            char[] buffer = new char[8192];
            while ((bytesRead = this.bufferedReader.read(buffer)) != -1) {
                String line = new String(buffer, 0, bytesRead);
                long timeStamp = System.currentTimeMillis();
                ConnectRecord connectRecord = new ConnectRecord(recordPartition, null, Long.valueOf(timeStamp), (Object)line);
                connectRecords.add(connectRecord);
            }
        }
        catch (IOException e) {
            log.error("Error reading data from the file: {}", (Object)e.getMessage());
        }
        return connectRecords;
    }

    public static RecordPartition convertToRecordPartition(String fileName) {
        FileRecordPartition fileRecordPartition = new FileRecordPartition();
        fileRecordPartition.setFileName(fileName);
        return fileRecordPartition;
    }

    private static String getFileName(String filePath) throws NullPointerException {
        File file = new File(filePath);
        return file.getName();
    }
}

