/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.UnicastSubject;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowBoundarySupplier<T, B>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final Callable<? extends ObservableSource<B>> other;
    final int bufferSize;

    public ObservableWindowBoundarySupplier(ObservableSource<T> source, Callable<? extends ObservableSource<B>> other, int bufferSize) {
        super(source);
        this.other = other;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> t) {
        this.source.subscribe(new WindowBoundaryMainObserver(new SerializedObserver<Observable<T>>(t), this.other, this.bufferSize));
    }

    static final class WindowBoundaryInnerObserver<T, B>
    extends DisposableObserver<B> {
        final WindowBoundaryMainObserver<T, B> parent;
        boolean done;

        WindowBoundaryInnerObserver(WindowBoundaryMainObserver<T, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.onComplete();
        }
    }

    static final class WindowBoundaryMainObserver<T, B>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Disposable {
        final Callable<? extends ObservableSource<B>> other;
        final int bufferSize;
        Disposable s;
        final AtomicReference<Disposable> boundary = new AtomicReference();
        UnicastSubject<T> window;
        static final Object NEXT = new Object();
        final AtomicLong windows = new AtomicLong();

        WindowBoundaryMainObserver(Observer<? super Observable<T>> actual, Callable<? extends ObservableSource<B>> other, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.other = other;
            this.bufferSize = bufferSize;
            this.windows.lazySet(1L);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                ObservableSource<B> p;
                this.s = s;
                Observer a = this.actual;
                a.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                try {
                    p = ObjectHelper.requireNonNull(this.other.call(), "The first window ObservableSource supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    s.dispose();
                    a.onError(e);
                    return;
                }
                UnicastSubject w = UnicastSubject.create(this.bufferSize);
                this.window = w;
                a.onNext(w);
                WindowBoundaryInnerObserver inner = new WindowBoundaryInnerObserver(this);
                if (this.boundary.compareAndSet(null, inner)) {
                    this.windows.getAndIncrement();
                    p.subscribe(inner);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.fastEnter()) {
                UnicastSubject<T> w = this.window;
                w.onNext(t);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                DisposableHelper.dispose(this.boundary);
            }
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                DisposableHelper.dispose(this.boundary);
            }
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drainLoop() {
            MpscLinkedQueue q = (MpscLinkedQueue)this.queue;
            Observer a = this.actual;
            int missed = 1;
            UnicastSubject w = this.window;
            while (true) {
                boolean empty;
                boolean d = this.done;
                Object o = q.poll();
                boolean bl = empty = o == null;
                if (d && empty) {
                    DisposableHelper.dispose(this.boundary);
                    Throwable e = this.error;
                    if (e != null) {
                        w.onError(e);
                    } else {
                        w.onComplete();
                    }
                    return;
                }
                if (!empty) {
                    if (o == NEXT) {
                        ObservableSource<B> p;
                        w.onComplete();
                        if (this.windows.decrementAndGet() == 0L) {
                            DisposableHelper.dispose(this.boundary);
                            return;
                        }
                        if (this.cancelled) continue;
                        try {
                            p = ObjectHelper.requireNonNull(this.other.call(), "The ObservableSource supplied is null");
                        }
                        catch (Throwable e) {
                            Exceptions.throwIfFatal(e);
                            DisposableHelper.dispose(this.boundary);
                            a.onError(e);
                            return;
                        }
                        w = UnicastSubject.create(this.bufferSize);
                        this.windows.getAndIncrement();
                        this.window = w;
                        a.onNext(w);
                        WindowBoundaryInnerObserver b = new WindowBoundaryInnerObserver(this);
                        if (!this.boundary.compareAndSet(this.boundary.get(), b)) continue;
                        p.subscribe(b);
                        continue;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        void next() {
            this.queue.offer(NEXT);
            if (this.enter()) {
                this.drainLoop();
            }
        }
    }
}

