/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import org.apache.eventmesh.common.Constants;

public class HttpResponseUtils {
    public static HttpResponse createSuccess() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    public static HttpResponse createNotFound() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
    }

    public static HttpResponse createInternalServerError() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    public static HttpResponse buildHttpResponse(String body, ChannelHandlerContext ctx, AsciiString headerValue, HttpResponseStatus status) {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)headerValue);
        return HttpResponseUtils.buildHttpResponse(body, ctx, (HttpHeaders)responseHeaders, status);
    }

    public static HttpResponse buildHttpResponse(String body, ChannelHandlerContext ctx, HttpHeaders responseHeaders, HttpResponseStatus status) {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, HttpResponseUtils.createByteBuf(ctx, body), responseHeaders, responseHeaders);
    }

    public static HttpHeaders buildDefaultHttpHeaders(AsciiString contentType) {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        responseHeaders.add("Access-Control-Allow-Origin", (Object)"*");
        return responseHeaders;
    }

    private static ByteBuf createByteBuf(ChannelHandlerContext ctx, String body) {
        byte[] bytes = body.getBytes(Constants.DEFAULT_CHARSET);
        ByteBuf byteBuf = ctx.alloc().buffer(bytes.length);
        byteBuf.writeBytes(bytes);
        return byteBuf;
    }
}

