/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);

    public static Map<String, String> formData2Dic(String formData) {
        if (StringUtils.isBlank((CharSequence)formData)) {
            return new HashMap<String, String>();
        }
        String[] items = formData.split("&");
        HashMap<String, String> result = new HashMap<String, String>(items.length);
        Arrays.stream(items).forEach(item -> {
            String[] keyAndVal = item.split("=");
            if (keyAndVal.length == 2) {
                try {
                    String key = URLDecoder.decode(keyAndVal[0], Constants.DEFAULT_CHARSET.name());
                    String val = URLDecoder.decode(keyAndVal[1], Constants.DEFAULT_CHARSET.name());
                    result.put(key, val);
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("formData2Dic:param decode failed...", (Throwable)e);
                }
            }
        });
        return result;
    }

    public static String addressToString(Collection<InetSocketAddress> clients) {
        if (clients.isEmpty()) {
            return "no session had been closed";
        }
        StringBuilder sb = new StringBuilder();
        for (InetSocketAddress addr : clients) {
            sb.append(addr).append("|");
        }
        return sb.toString();
    }
}

