/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ReflectionTypeReference;
import org.springframework.aot.hint.SimpleTypeReference;

public interface TypeReference
extends Comparable<TypeReference> {
    public String getName();

    public String getCanonicalName();

    public String getPackageName();

    public String getSimpleName();

    public @Nullable TypeReference getEnclosingType();

    public static TypeReference of(Class<?> type) {
        return ReflectionTypeReference.of(type);
    }

    public static TypeReference of(String className) {
        return SimpleTypeReference.of(className);
    }

    public static List<TypeReference> listOf(Class<?> ... types) {
        return Arrays.stream(types).map(TypeReference::of).toList();
    }
}

