/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.slf4j.Logger;

public class ScriptedBiFunction<T, U, V>
extends AbstractScriptEvaluator
implements BiFunction<T, U, V> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedBiFunction.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    protected ScriptedBiFunction(@Nonnull @NotEmpty EvaluableScript theScript, @Nullable @NotEmpty String extraInfo) {
        super(theScript);
        this.setLogPrefix("Scripted BiFunction from " + extraInfo + ":");
    }

    protected ScriptedBiFunction(@Nonnull @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous BiFunction:");
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    @Nullable
    public V apply(@Nullable T first, @Nullable U second) {
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            Class<T> intype1 = types.getFirst();
            Class<U> intype2 = types.getSecond();
            if (null != first && null != intype1 && !intype1.isInstance(first)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), first.getClass(), intype1});
                return (V)this.getReturnOnError();
            }
            if (null != second && null != intype2 && !intype2.isInstance(second)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), second.getClass(), intype2});
                return (V)this.getReturnOnError();
            }
        }
        return (V)this.evaluate(first, second);
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input1", input != null ? input[0] : null, 100);
        scriptContext.setAttribute("input2", input != null ? input[1] : null, 100);
    }

    @Nonnull
    public static <T, U, V> ScriptedBiFunction<T, U, V> resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initialize();
            ScriptedBiFunction<T, U, V> scriptedBiFunction = new ScriptedBiFunction<T, U, V>(script, resource.getDescription());
            return scriptedBiFunction;
        }
    }

    @Nonnull
    public static <T, U, V> ScriptedBiFunction<T, U, V> resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedBiFunction.resourceScript("JavaScript", resource);
    }

    @Nonnull
    public static <T, U, V> ScriptedBiFunction<T, U, V> inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedBiFunction<T, U, V>(script, "Inline");
    }

    @Nonnull
    public static <T, U, V> ScriptedBiFunction<T, U, V> inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedBiFunction<T, U, V>(script, "Inline");
    }
}

