/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import java.util.Iterator;
import java.util.Set;

public class JsonContent {
    private JsonObject jsonObject = null;
    private JsonArray jsonArray = null;

    private static Object wrapIfNeeded(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (obj instanceof JsonArray) {
            return new JsonContent((JsonArray)obj);
        }
        if (obj instanceof JsonObject) {
            return new JsonContent((JsonObject)obj);
        }
        return obj;
    }

    public JsonContent(JsonObject object) {
        this.jsonObject = object;
    }

    public JsonContent(JsonArray array) {
        this.jsonArray = array;
    }

    public Object get(int index) {
        Object ret = null;
        if (this.jsonArray != null) {
            ret = JsonContent.wrapIfNeeded(this.jsonArray.get(index));
        } else if (this.jsonObject != null) {
            ret = JsonContent.wrapIfNeeded(this.jsonObject.get(String.valueOf(index)));
        }
        return ret;
    }

    public Object get(String key) {
        Object ret = null;
        if (this.jsonArray != null) {
            try {
                ret = JsonContent.wrapIfNeeded(this.jsonArray.get(Integer.parseInt(key)));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.jsonObject != null) {
            ret = JsonContent.wrapIfNeeded(this.jsonObject.get(key));
        }
        return ret;
    }

    public Iterator<String> keys() {
        return this.jsonObject == null ? null : this.jsonObject.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.jsonObject == null ? null : this.jsonObject.keySet();
    }

    public Iterator iterator() {
        if (this.jsonObject != null) {
            return this.jsonObject.keySet().iterator();
        }
        if (this.jsonArray != null) {
            return this.jsonArray.iterator();
        }
        return null;
    }

    public int size() {
        return this.jsonObject == null ? (this.jsonArray == null ? null : Integer.valueOf(this.jsonArray.size())).intValue() : this.jsonObject.size();
    }

    public String toString() {
        return this.jsonObject == null ? (this.jsonArray == null ? "null" : this.jsonArray.toString()) : this.jsonObject.toString();
    }

    public boolean isNull() {
        return this.jsonArray == null && this.jsonObject == null;
    }

    public boolean isObject() {
        return this.jsonObject != null;
    }

    public boolean isArray() {
        return this.jsonArray != null;
    }

    public JsonObject getObject() {
        return this.jsonObject;
    }

    public JsonArray getArray() {
        return this.jsonArray;
    }
}

