/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.TestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

class Exec62Test {
    private Path outputFile;

    Exec62Test() {
    }

    private void execute(String scriptName) throws Exception {
        ExecuteWatchdog watchdog = new ExecuteWatchdog(4000L);
        CommandLine commandLine = new CommandLine("/bin/sh");
        File testScript = TestUtil.resolveScriptFileForOS("./src/test/scripts/issues/" + scriptName);
        commandLine.addArgument(testScript.getAbsolutePath());
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setExitValues(null);
        executor.setWatchdog(watchdog);
        try (OutputStream fos = Files.newOutputStream(this.outputFile, new OpenOption[0]);){
            PumpStreamHandler streamHandler = new PumpStreamHandler(fos);
            executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            executor.execute(commandLine);
            if (watchdog.killedProcess()) {
                throw new TimeoutException(String.format("Transcode process was killed on timeout %1$s ms, command line %2$s", 4000, commandLine.toString()));
            }
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.outputFile = Files.createTempFile("foo", ".log", new FileAttribute[0]);
    }

    @AfterEach
    public void tearDown() throws Exception {
        Files.delete(this.outputFile);
    }

    @Disabled(value="Test behaves differently between macOS X and Linux - don't know why")
    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    @Timeout(value=10L, unit=TimeUnit.SECONDS)
    void testMe() throws Exception {
        this.execute("exec-62");
    }
}

