/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.mapper;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

public abstract class MapperBuilder<MapperT> {
    public static final String SCHEMA_VALIDATION_ENABLED_SETTING = "datastax.mapper.schemaValidationEnabled";
    protected final CqlSession session;
    protected CqlIdentifier defaultKeyspaceId;
    protected Map<Object, Object> customState;
    protected String defaultExecutionProfileName;
    protected DriverExecutionProfile defaultExecutionProfile;

    protected MapperBuilder(CqlSession session) {
        this.session = session;
        this.customState = new HashMap<Object, Object>();
        this.customState.put(SCHEMA_VALIDATION_ENABLED_SETTING, true);
    }

    @NonNull
    public MapperBuilder<MapperT> withDefaultKeyspace(@Nullable CqlIdentifier keyspaceId) {
        this.defaultKeyspaceId = keyspaceId;
        return this;
    }

    @NonNull
    public MapperBuilder<MapperT> withDefaultKeyspace(@Nullable String keyspaceName) {
        return this.withDefaultKeyspace(keyspaceName == null ? null : CqlIdentifier.fromCql((String)keyspaceName));
    }

    @NonNull
    public MapperBuilder<MapperT> withDefaultExecutionProfileName(@Nullable String executionProfileName) {
        this.defaultExecutionProfileName = executionProfileName;
        if (executionProfileName != null) {
            this.defaultExecutionProfile = null;
        }
        return this;
    }

    @NonNull
    public MapperBuilder<MapperT> withDefaultExecutionProfile(@Nullable DriverExecutionProfile executionProfile) {
        this.defaultExecutionProfile = executionProfile;
        if (executionProfile != null) {
            this.defaultExecutionProfileName = null;
        }
        return this;
    }

    public MapperBuilder<MapperT> withSchemaValidationEnabled(boolean enableSchemaValidation) {
        this.customState.put(SCHEMA_VALIDATION_ENABLED_SETTING, enableSchemaValidation);
        return this;
    }

    @NonNull
    public MapperBuilder<MapperT> withCustomState(@Nullable Object key, @Nullable Object value) {
        this.customState.put(key, value);
        return this;
    }

    public abstract MapperT build();
}

