/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.avro.AvroDataUtils;
import org.apache.cassandra.cdc.avro.CdcEventAvroEncoder;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.Preconditions;

public abstract class AvroBaseRecordTransformer<T extends BaseSerializedEvent<P>, P>
extends CdcEventAvroEncoder {
    public static final int DEFAULT_TRUNCATE_THRESHOLD = 838860;
    protected final int truncateThreshold;

    public AvroBaseRecordTransformer(SchemaStore store, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, String templatePath) {
        this(store, typeLookup, 838860, templatePath);
    }

    public AvroBaseRecordTransformer(SchemaStore store, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, int truncateThreshold, String templatePath) {
        super(store, typeLookup, templatePath);
        this.truncateThreshold = truncateThreshold;
    }

    public abstract T serializeEvent(CdcEvent var1);

    public abstract GenericData.Record buildRecordWithPayload(T var1);

    @Override
    public GenericData.Record transform(CdcEvent event) {
        T serializedEvent = this.serializeEvent(event);
        GenericData.Record record = this.buildRecordWithPayload(serializedEvent);
        Function<Value, Object> predicateFieldEncoder = field -> {
            ByteBuffer fieldValue = field.getValue();
            Preconditions.checkNotNull((Object)fieldValue, (String)"Field value of column %s should not be null for range predicate", (Object[])new Object[]{field.columnName});
            Schema tableSchema = this.store.getSchema(event.keyspace + "." + event.table, null);
            Schema.Field column = tableSchema.getField(field.columnName);
            Preconditions.checkNotNull((Object)column, (String)"Encountered an unknown field during range predicate encoding. Field: %s. Avro schema: %s", (Object[])new Object[]{field.columnName, tableSchema.getFullName()});
            GenericData.Record update = new GenericData.Record(tableSchema);
            CqlField.CqlType type = (CqlField.CqlType)this.typeLookup.apply(KeyspaceTypeKey.of((String)event.keyspace, (String)field.columnType));
            Object javaValue = type.deserializeToJavaType(fieldValue);
            update.put(field.columnName, AvroDataUtils.toAvro(javaValue, column.schema()));
            return ByteBuffer.wrap(this.encode(this.store.getWriter(event.keyspace + "." + event.table, null), update));
        };
        this.applyCommonFields(event, record, predicateFieldEncoder);
        String schemaUuid = this.store.getVersion(event.keyspace + "." + event.table, null);
        record.put("schemaUuid", (Object)schemaUuid);
        record.put("truncatedFields", ((BaseSerializedEvent)serializedEvent).truncatedFields);
        return record;
    }

    public static abstract class BaseSerializedEvent<P> {
        public final P payload;
        public final List<String> truncatedFields;

        public BaseSerializedEvent(P payload, List<String> truncatedFields) {
            this.payload = payload;
            this.truncatedFields = truncatedFields;
        }
    }
}

