/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.XXHash32Digest;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.commons.codec.digest.XXHash32;

public class XXHash32DigestAlgorithm
implements DigestAlgorithm {
    private static final int KIB_512 = 524288;
    private static final int SEED = 0;

    @Override
    public Digest calculateFileDigest(Path path) throws IOException {
        XXHash32 hasher = new XXHash32(0);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[524288];
            while ((len = inputStream.read(buffer)) != -1) {
                hasher.update(buffer, 0, len);
            }
            XXHash32Digest xXHash32Digest = new XXHash32Digest(Long.toHexString(hasher.getValue()), 0);
            return xXHash32Digest;
        }
    }
}

