/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleNameGenerator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableCollector;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableLister;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableListerTest;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTablesBundler;
import org.apache.cassandra.spark.bulkwriter.util.IOUtils;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.data.FileSystemSSTable;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.utils.TemporaryDirectory;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SSTablesBundlerTest {
    private final String jobId = UUID.randomUUID().toString();
    private final String sessionId = "1-" + String.valueOf(UUID.randomUUID());

    SSTablesBundlerTest() {
    }

    @Test
    void testNumberOfBundlesGenerated() throws IOException, URISyntaxException {
        try (TemporaryDirectory tempDir = new TemporaryDirectory();){
            BundleNameGenerator nameGenerator = new BundleNameGenerator(this.jobId, this.sessionId);
            Path sourceDir = Paths.get(this.getClass().getResource("/data/ks/table1-ea3b3e6b-0d78-4913-89f2-15fcf98711d0").toURI());
            Path outputDir = tempDir.path();
            FileUtils.copyDirectory((File)sourceDir.toFile(), (File)outputDir.toFile());
            Map<Path, Digest> fileDigests = SSTableListerTest.calculateFileDigests(outputDir);
            CassandraBridge bridge = this.mockCassandraBridge(outputDir);
            SSTableLister ssTableLister = new SSTableLister(new QualifiedTableName("ks", "table1"), bridge);
            ssTableLister.includeFileDigests(fileDigests);
            SSTablesBundler ssTablesBundler = new SSTablesBundler(outputDir, (SSTableCollector)ssTableLister, nameGenerator, 5120L);
            ssTablesBundler.includeDirectory(outputDir);
            ssTablesBundler.finish();
            ImmutableList bundles = ImmutableList.copyOf((Iterator)ssTablesBundler);
            Assertions.assertThat((List)bundles).hasSize(2);
            Path bundle0 = outputDir.resolve("0");
            Path bundle1 = outputDir.resolve("1");
            Assertions.assertThat((Path)bundle0).exists().isDirectory();
            Assertions.assertThat((Path)bundle1).exists().isDirectory();
            String expectedZippedBundlePath1 = "b_" + this.jobId + "_" + this.sessionId + "_1_3";
            String expectedZippedBundlePath2 = "e_" + this.jobId + "_" + this.sessionId + "_4_6";
            Assertions.assertThat((Path)outputDir.resolve(expectedZippedBundlePath1)).exists();
            Assertions.assertThat((Path)outputDir.resolve(expectedZippedBundlePath2)).exists();
        }
    }

    @Test
    void testManifestWritten() throws IOException, URISyntaxException {
        try (TemporaryDirectory tempDir = new TemporaryDirectory();){
            BundleNameGenerator nameGenerator = new BundleNameGenerator(this.jobId, this.sessionId);
            Path sourceDir = Paths.get(this.getClass().getResource("/data/ks/table1-ea3b3e6b-0d78-4913-89f2-15fcf98711d0").toURI());
            Path outputDir = tempDir.path();
            FileUtils.copyDirectory((File)sourceDir.toFile(), (File)outputDir.toFile());
            Map<Path, Digest> fileDigests = SSTableListerTest.calculateFileDigests(outputDir);
            CassandraBridge bridge = this.mockCassandraBridge(outputDir);
            SSTableLister writerOutputAnalyzer = new SSTableLister(new QualifiedTableName("ks", "table1"), bridge);
            writerOutputAnalyzer.includeFileDigests(fileDigests);
            SSTablesBundler ssTablesBundler = new SSTablesBundler(outputDir, (SSTableCollector)writerOutputAnalyzer, nameGenerator, 5120L);
            ssTablesBundler.includeDirectory(outputDir);
            ssTablesBundler.finish();
            while (ssTablesBundler.hasNext()) {
                ssTablesBundler.next();
            }
            String expectedBundle0Manifest = "{\n  \"na-1-big-\" : {\n    \"components_checksum\" : {\n      \"na-1-big-Summary.db\" : \"e2c32c23\",\n      \"na-1-big-TOC.txt\" : \"7c8ef1f5\",\n      \"na-1-big-Filter.db\" : \"72fc4f9c\",\n      \"na-1-big-Index.db\" : \"ee128018\",\n      \"na-1-big-Data.db\" : \"f48b39a3\",\n      \"na-1-big-Statistics.db\" : \"f773fcc6\"\n    },\n    \"start_token\" : 1,\n    \"end_token\" : 3\n  }\n}";
            String expectedBundle1Manifest = "{\n  \"na-2-big-\" : {\n    \"components_checksum\" : {\n      \"na-2-big-Filter.db\" : \"72fc4f9c\",\n      \"na-2-big-TOC.txt\" : \"7c8ef1f5\",\n      \"na-2-big-Index.db\" : \"ee128018\",\n      \"na-2-big-Data.db\" : \"f48b39a3\",\n      \"na-2-big-Summary.db\" : \"e2c32c23\",\n      \"na-2-big-Statistics.db\" : \"f773fcc6\"\n    },\n    \"start_token\" : 4,\n    \"end_token\" : 6\n  }\n}";
            Path bundle0Manifest = outputDir.resolve("0").resolve("manifest.json");
            Path bundle1Manifest = outputDir.resolve("1").resolve("manifest.json");
            Assertions.assertThat((Path)bundle0Manifest).exists();
            Assertions.assertThat((Path)bundle1Manifest).exists();
            ObjectMapper mapper = new ObjectMapper();
            Map actualBundle0 = (Map)mapper.readValue(bundle0Manifest.toFile(), Map.class);
            Map expectedBundle0 = (Map)mapper.readValue(expectedBundle0Manifest, Map.class);
            Assertions.assertThat((Map)actualBundle0).isEqualTo((Object)expectedBundle0);
            Map actualBundle1 = (Map)mapper.readValue(bundle1Manifest.toFile(), Map.class);
            Map expectedBundle1 = (Map)mapper.readValue(expectedBundle1Manifest, Map.class);
            Assertions.assertThat((Map)actualBundle1).isEqualTo((Object)expectedBundle1);
        }
    }

    @Test
    void testChecksumComputedForEmptyFile() throws IOException {
        try (TemporaryDirectory tempDir = new TemporaryDirectory();){
            Path empty = Files.createFile(tempDir.path().resolve("empty"), new FileAttribute[0]);
            Assertions.assertThat((String)IOUtils.xxhash32((Path)empty)).isEqualTo("2cc5d05");
        }
    }

    @Test
    void testEmptyOutputDir() throws IOException {
        try (TemporaryDirectory tempDir = new TemporaryDirectory();){
            BundleNameGenerator nameGenerator = new BundleNameGenerator(this.jobId, this.sessionId);
            Path outputDir = tempDir.path();
            CassandraBridge bridge = this.mockCassandraBridge(outputDir);
            SSTableLister ssTableLister = new SSTableLister(new QualifiedTableName("ks", "table1"), bridge);
            SSTablesBundler ssTablesBundler = new SSTablesBundler(outputDir, (SSTableCollector)ssTableLister, nameGenerator, 200L);
            Assertions.assertThatThrownBy(() -> ((SSTablesBundler)ssTablesBundler).next()).isInstanceOf(NoSuchElementException.class);
        }
    }

    private CassandraBridge mockCassandraBridge(Path outputDir) {
        CassandraBridge bridge = (CassandraBridge)Mockito.mock(CassandraBridge.class);
        SSTableSummary summary1 = new SSTableSummary(BigInteger.valueOf(1L), BigInteger.valueOf(3L), "na-1-big-");
        SSTableSummary summary2 = new SSTableSummary(BigInteger.valueOf(4L), BigInteger.valueOf(6L), "na-2-big-");
        FileSystemSSTable ssTable1 = new FileSystemSSTable(outputDir.resolve("na-1-big-Data.db"), false, null);
        FileSystemSSTable ssTable2 = new FileSystemSSTable(outputDir.resolve("na-2-big-Data.db"), false, null);
        Mockito.when((Object)bridge.getSSTableSummary("ks", "table1", (SSTable)ssTable1)).thenReturn((Object)summary1);
        Mockito.when((Object)bridge.getSSTableSummary("ks", "table1", (SSTable)ssTable2)).thenReturn((Object)summary2);
        return bridge;
    }
}

