/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.apache.cassandra.bridge.PostDelegationClassLoader;
import org.jetbrains.annotations.NotNull;

public class BaseCassandraBridgeFactory {
    protected BaseCassandraBridgeFactory() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    @NotNull
    public static CassandraVersion getCassandraVersion(@NotNull String version) {
        CassandraVersionFeatures features = CassandraVersionFeatures.cassandraVersionFeaturesFromCassandraVersion((String)version);
        Preconditions.checkArgument((features != null ? 1 : 0) != 0, (Object)("Cassandra version " + version + " is not supported"));
        return BaseCassandraBridgeFactory.getCassandraVersion(features);
    }

    @NotNull
    public static CassandraVersion getCassandraVersion(@NotNull CassandraVersionFeatures features) {
        Optional<CassandraVersion> version = Arrays.stream(CassandraVersion.values()).filter(value -> value.versionNumber() == features.getMajorVersion()).findAny();
        Preconditions.checkArgument((boolean)version.isPresent(), (Object)("Cassandra features " + String.valueOf(features) + " are not supported"));
        return version.get();
    }

    public static void validateBridges(CassandraVersion[] expectedCassandraVersions) {
        for (CassandraVersion version : expectedCassandraVersions) {
            String jarBaseName = version.jarBaseName();
            String cassandraResourceName = BaseCassandraBridgeFactory.cassandraResourceName(jarBaseName);
            URL locator = BaseCassandraBridgeFactory.class.getResource(cassandraResourceName);
            if (locator == null) {
                throw new IllegalStateException("Missing Cassandra implementation for version " + String.valueOf(version));
            }
            String bridgeResourceName = BaseCassandraBridgeFactory.bridgeResourceName(jarBaseName);
            locator = BaseCassandraBridgeFactory.class.getResource(bridgeResourceName);
            if (locator != null) continue;
            throw new IllegalStateException("Missing Cassandra bridge implementation for version " + String.valueOf(version));
        }
    }

    public static CassandraBridge loadCassandraBridge(String label) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ClassLoader loader = BaseCassandraBridgeFactory.buildClassLoader(BaseCassandraBridgeFactory.cassandraResourceName(label), BaseCassandraBridgeFactory.bridgeResourceName(label), BaseCassandraBridgeFactory.typesResourceName(label));
        Class<?> bridge = loader.loadClass("org.apache.cassandra.bridge.CassandraBridgeImplementation");
        Constructor<?> constructor = bridge.getConstructor(new Class[0]);
        return (CassandraBridge)constructor.newInstance(new Object[0]);
    }

    public static ClassLoader buildClassLoader(String ... resourceNames) {
        URL[] urls = (URL[])Arrays.stream(resourceNames).map(BaseCassandraBridgeFactory::copyClassResourceToFile).map(jar -> {
            try {
                return jar.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        return new PostDelegationClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public static File copyClassResourceToFile(String resource) {
        File file;
        block9: {
            InputStream contents = BaseCassandraBridgeFactory.class.getResourceAsStream(resource);
            try {
                if (contents == null) {
                    throw new NullPointerException("Could not find resource: " + resource);
                }
                Path jarPath = Files.createTempFile(null, ".jar", new FileAttribute[0]);
                Files.copy(contents, jarPath, StandardCopyOption.REPLACE_EXISTING);
                file = jarPath.toFile();
                if (contents == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            contents.close();
        }
        return file;
    }

    @NotNull
    static String cassandraResourceName(@NotNull String label) {
        return "/bridges/" + label + ".jar";
    }

    @NotNull
    static String bridgeResourceName(@NotNull String label) {
        return BaseCassandraBridgeFactory.jarResourceName(label, "bridge");
    }

    @NotNull
    static String typesResourceName(@NotNull String label) {
        return BaseCassandraBridgeFactory.jarResourceName(label, "types");
    }

    @NotNull
    static String avroResourceName(@NotNull String label) {
        return BaseCassandraBridgeFactory.jarResourceName(label, "avro");
    }

    static String jarResourceName(String ... parts) {
        return "/bridges/" + String.join((CharSequence)"-", parts) + ".jar";
    }
}

