/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.compress.ZstdCompressor;

final class CompressionUtils {
    CompressionUtils() {
    }

    public ICompressor compressor() {
        return ZstdCompressor.getOrCreate((int)3);
    }

    public ByteBuffer compress(byte[] bytes) throws IOException {
        ICompressor compressor = this.compressor();
        ByteBuffer input = compressor.preferredBufferType().allocate(bytes.length);
        input.put(bytes);
        input.flip();
        return this.compress(input, compressor);
    }

    public ByteBuffer compress(ByteBuffer input) throws IOException {
        return this.compress(input, this.compressor());
    }

    public ByteBuffer compress(ByteBuffer input, ICompressor compressor) throws IOException {
        int rawSize = input.remaining();
        ByteBuffer output = compressor.preferredBufferType().allocate(4 + compressor.initialCompressedBufferLength(rawSize));
        output.putInt(rawSize);
        compressor.compress(input, output);
        output.flip();
        return output;
    }

    public ByteBuffer uncompress(byte[] bytes) throws IOException {
        ICompressor compressor = this.compressor();
        ByteBuffer input = compressor.preferredBufferType().allocate(bytes.length);
        input.put(bytes);
        input.flip();
        return this.uncompress(input, compressor);
    }

    public ByteBuffer uncompress(ByteBuffer input) throws IOException {
        return this.uncompress(input, this.compressor());
    }

    public ByteBuffer uncompress(ByteBuffer input, ICompressor compressor) throws IOException {
        ByteBuffer output = compressor.preferredBufferType().allocate(input.getInt());
        compressor.uncompress(input, output);
        output.flip();
        return output;
    }
}

