/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.AbstractBufferClusteringPrefix;
import org.apache.cassandra.db.BufferClustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public interface Clustering<V>
extends ClusteringPrefix<V> {
    public static final Serializer serializer = new Serializer();
    public static final Clustering<ByteBuffer> STATIC_CLUSTERING = new BufferClustering(AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY){

        @Override
        public ClusteringPrefix.Kind kind() {
            return ClusteringPrefix.Kind.STATIC_CLUSTERING;
        }

        public String toString() {
            return "STATIC";
        }

        @Override
        public String toString(TableMetadata metadata) {
            return this.toString();
        }
    };
    public static final Clustering<ByteBuffer> EMPTY = new BufferClustering(AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY){

        @Override
        public String toString(TableMetadata metadata) {
            return "EMPTY";
        }
    };

    public long unsharedHeapSizeExcludingData();

    default public Clustering<?> clone(ByteBufferCloner cloner) {
        if (this.size() == 0) {
            return this.kind() == ClusteringPrefix.Kind.STATIC_CLUSTERING ? this : EMPTY;
        }
        ByteBuffer[] newValues = new ByteBuffer[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ByteBuffer val = this.accessor().toBuffer(this.get(i));
            newValues[i] = val == null ? null : cloner.clone(val);
        }
        return new BufferClustering(newValues);
    }

    @Override
    default public String toString(TableMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            ColumnMetadata c = (ColumnMetadata)metadata.clusteringColumns().get(i);
            sb.append(i == 0 ? "" : ", ").append(c.name).append('=').append(this.get(i) == null ? "null" : c.type.getString(this.get(i), this.accessor()));
        }
        return sb.toString();
    }

    default public String toCQLString(TableMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            ColumnMetadata c = (ColumnMetadata)metadata.clusteringColumns().get(i);
            sb.append(i == 0 ? "" : ", ").append(c.type.getString(this.get(i), this.accessor()));
        }
        return sb.toString();
    }

    public static Clustering<ByteBuffer> make(ByteBuffer ... values) {
        return values.length == 0 ? EMPTY : new BufferClustering(values);
    }

    public static class Serializer {
        public void serialize(Clustering<?> clustering, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            assert (clustering != STATIC_CLUSTERING) : "We should never serialize a static clustering";
            assert (clustering.size() == types.size()) : "Invalid clustering for the table: " + clustering;
            ClusteringPrefix.serializer.serializeValuesWithoutSize(clustering, out, version, types);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteBuffer serialize(Clustering<?> clustering, int version, List<AbstractType<?>> types) {
            try (DataOutputBuffer buffer = new DataOutputBuffer((int)this.serializedSize(clustering, version, types));){
                this.serialize(clustering, buffer, version, types);
                ByteBuffer byteBuffer = buffer.buffer();
                return byteBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException("Writing to an in-memory buffer shouldn't trigger an IOException", e);
            }
        }

        public long serializedSize(Clustering<?> clustering, int version, List<AbstractType<?>> types) {
            return ClusteringPrefix.serializer.valuesWithoutSizeSerializedSize(clustering, version, types);
        }

        public void skip(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            if (!types.isEmpty()) {
                ClusteringPrefix.serializer.skipValuesWithoutSize(in, types.size(), version, types);
            }
        }

        public Clustering<byte[]> deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            if (types.isEmpty()) {
                return ByteArrayAccessor.factory.clustering();
            }
            byte[][] values = ClusteringPrefix.serializer.deserializeValuesWithoutSize(in, types.size(), version, types);
            return ByteArrayAccessor.factory.clustering((V[])values);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Clustering<byte[]> deserialize(ByteBuffer in, int version, List<AbstractType<?>> types) {
            try (DataInputBuffer buffer = new DataInputBuffer(in, true);){
                Clustering<byte[]> clustering = this.deserialize(buffer, version, types);
                return clustering;
            }
            catch (IOException e) {
                throw new RuntimeException("Reading from an in-memory buffer shouldn't trigger an IOException", e);
            }
        }
    }
}

