/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.data.ConsistencyConfig;
import org.apache.cassandra.sidecar.common.data.ConsistencyLevel;
import org.apache.cassandra.sidecar.common.data.RestoreJobSecrets;
import org.apache.cassandra.sidecar.common.data.SSTableImportOptions;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.common.utils.StringUtils;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class CreateRestoreJobRequestPayload {
    private final UUID jobId;
    private final String jobAgent;
    private final RestoreJobSecrets secrets;
    private final SSTableImportOptions importOptions;
    private final long expireAtInMillis;
    private final ConsistencyConfig consistencyConfig;
    private final boolean localDatacenterOnly;

    public static Builder builder(RestoreJobSecrets secrets, long expireAtInMillis) {
        return new Builder(secrets, expireAtInMillis);
    }

    @JsonCreator
    public CreateRestoreJobRequestPayload(@JsonProperty(value="jobId") UUID jobId, @JsonProperty(value="jobAgent") String jobAgent, @JsonProperty(value="secrets") RestoreJobSecrets secrets, @JsonProperty(value="importOptions") SSTableImportOptions importOptions, @JsonProperty(value="expireAt") long expireAtInMillis, @JsonProperty(value="consistencyLevel") String consistencyLevel, @JsonProperty(value="localDatacenter") String localDatacenter, @JsonProperty(value="restoreToLocalDatacenterOnly") boolean localDatacenterOnly) {
        Preconditions.checkArgument(jobId == null || jobId.version() == 1, "Only time based UUIDs allowed for jobId");
        Preconditions.checkArgument(expireAtInMillis != 0L && expireAtInMillis > System.currentTimeMillis(), "expireAt cannot be absent or a time in past");
        Objects.requireNonNull(secrets, "secrets cannot be null");
        this.jobId = jobId;
        this.jobAgent = jobAgent;
        this.secrets = secrets;
        this.importOptions = importOptions == null ? SSTableImportOptions.defaults() : importOptions;
        this.expireAtInMillis = expireAtInMillis;
        this.consistencyConfig = ConsistencyConfig.parseString(consistencyLevel, localDatacenter);
        Preconditions.checkArgument(!localDatacenterOnly || StringUtils.isNotEmpty(localDatacenter), "Must specify a localDatacenter when restoreToLocalDatacenterOnly is true");
        this.localDatacenterOnly = localDatacenterOnly;
    }

    private CreateRestoreJobRequestPayload(Builder builder) {
        this(builder.jobId, builder.jobAgent, builder.secrets, builder.importOptions, builder.expireAtInMillis, CreateRestoreJobRequestPayload.nameOrNull(builder.consistencyLevel), builder.localDc, builder.localDatacenterOnly);
    }

    @JsonProperty(value="jobId")
    public UUID jobId() {
        return this.jobId;
    }

    @JsonProperty(value="jobAgent")
    public String jobAgent() {
        return this.jobAgent;
    }

    @JsonProperty(value="secrets")
    public RestoreJobSecrets secrets() {
        return this.secrets;
    }

    @JsonProperty(value="importOptions")
    public SSTableImportOptions importOptions() {
        return this.importOptions;
    }

    @JsonProperty(value="expireAt")
    public long expireAtInMillis() {
        return this.expireAtInMillis;
    }

    public Date expireAtAsDate() {
        return new Date(this.expireAtInMillis);
    }

    @JsonProperty(value="consistencyLevel")
    @Nullable
    public String consistencyLevel() {
        return CreateRestoreJobRequestPayload.nameOrNull(this.consistencyConfig.consistencyLevel);
    }

    @JsonProperty(value="localDatacenter")
    @Nullable
    public String localDatacenter() {
        return this.consistencyConfig.localDatacenter;
    }

    @JsonProperty(value="restoreToLocalDatacenterOnly")
    public boolean shouldRestoreToLocalDatacenterOnly() {
        return this.localDatacenterOnly;
    }

    public ConsistencyConfig consistencyConfig() {
        return this.consistencyConfig;
    }

    public String toString() {
        return "CreateRestoreJobRequest{jobId='" + String.valueOf(this.jobId) + "', jobAgent='" + this.jobAgent + "', secrets='" + String.valueOf(this.secrets) + "', expireAt='" + this.expireAtInMillis + "', consistencyLevel='" + this.consistencyLevel() + "', localDatacenter='" + this.localDatacenter() + "', restoreToLocalDatacenterOnly='" + this.shouldRestoreToLocalDatacenterOnly() + "', importOptions='" + String.valueOf(this.importOptions) + "'}";
    }

    private static String nameOrNull(ConsistencyLevel cl) {
        return cl == null ? null : cl.name();
    }

    public static class Builder
    implements DataObjectBuilder<Builder, CreateRestoreJobRequestPayload> {
        private final RestoreJobSecrets secrets;
        private final SSTableImportOptions importOptions = SSTableImportOptions.defaults();
        private final long expireAtInMillis;
        private UUID jobId = null;
        private String jobAgent = null;
        private ConsistencyLevel consistencyLevel = null;
        private String localDc = null;
        private boolean localDatacenterOnly = false;

        Builder(RestoreJobSecrets secrets, long expireAtInMillis) {
            this.secrets = secrets;
            this.expireAtInMillis = expireAtInMillis;
        }

        public Builder jobId(UUID jobId) {
            return this.update(b -> {
                b.jobId = jobId;
            });
        }

        public Builder jobAgent(String jobAgent) {
            return this.update(b -> {
                b.jobAgent = jobAgent;
            });
        }

        public Builder updateImportOptions(Consumer<SSTableImportOptions> updater) {
            return this.update(b -> updater.accept(b.importOptions));
        }

        public Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            return this.consistencyLevel(consistencyLevel, null);
        }

        public Builder consistencyLevel(ConsistencyLevel consistencyLevel, String localDc) {
            return this.update(b -> {
                b.consistencyLevel = consistencyLevel;
                b.localDc = localDc;
            });
        }

        public Builder restoreToLocalDatacenterOnly(boolean localDatacenterOnly) {
            return this.update(b -> {
                b.localDatacenterOnly = localDatacenterOnly;
            });
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public CreateRestoreJobRequestPayload build() {
            Preconditions.checkArgument(this.consistencyLevel == null || !this.consistencyLevel.isLocalDcOnly || this.localDc != null && !this.localDc.isEmpty(), "Must specify a non-empty localDatacenter for consistency level: " + String.valueOf((Object)this.consistencyLevel));
            return new CreateRestoreJobRequestPayload(this);
        }
    }
}

