/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.complex;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ValueComparators;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.complex.CqlCollection;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.utils.Pair;

public class CqlMap
extends CqlCollection
implements CqlField.CqlMap {
    public CqlMap(CqlField.CqlType keyType, CqlField.CqlType valueType) {
        super(keyType, valueType);
    }

    public CqlField.CqlType keyType() {
        return this.type();
    }

    public CqlField.CqlType valueType() {
        return this.type(1);
    }

    @Override
    public AbstractType<?> dataType(boolean isMultiCell) {
        return MapType.getInstance(((CqlType)this.keyType()).dataType(), ((CqlType)this.valueType()).dataType(), (boolean)isMultiCell);
    }

    @Override
    public <T> TypeSerializer<T> serializer() {
        return MapSerializer.getInstance(((CqlType)this.keyType()).serializer(), ((CqlType)this.valueType()).serializer(), (ValueComparators)((CqlType)this.keyType()).dataType().comparatorSet);
    }

    public CqlField.CqlType.InternalType internalType() {
        return CqlField.CqlType.InternalType.Map;
    }

    public String name() {
        return "map";
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return IntStream.range(0, RandomUtils.RANDOM.nextInt(16) + minCollectionSize).mapToObj(entry -> Pair.create((Object)this.keyType().randomValue(minCollectionSize), (Object)this.valueType().randomValue(minCollectionSize))).collect(Collectors.toMap(Pair::left, Pair::right, (first, second) -> first));
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setMap(position, (Map)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.map((DataType)((CqlType)this.keyType()).driverDataType(isFrozen), (DataType)((CqlType)this.valueType()).driverDataType(isFrozen));
    }

    public Object convertForCqlWriter(Object value, CassandraVersion version, boolean isCollectionElement) {
        Map map = (Map)value;
        return map.entrySet().stream().collect(Collectors.toMap(element -> this.keyType().convertForCqlWriter(element.getKey(), version, true), element -> this.valueType().convertForCqlWriter(element.getValue(), version, true)));
    }

    @Override
    public void addCell(Row.Builder rowBuilder, ColumnMetadata cd, long timestamp, int ttl, int now, Object value) {
        for (Map.Entry entry : ((Map)value).entrySet()) {
            if (ttl != 0) {
                rowBuilder.addCell((Cell)BufferCell.expiring((ColumnMetadata)cd, (long)timestamp, (int)ttl, (int)now, (ByteBuffer)this.valueType().serialize(entry.getValue()), (CellPath)CellPath.create((ByteBuffer)this.keyType().serialize(entry.getKey()))));
                continue;
            }
            rowBuilder.addCell((Cell)BufferCell.live((ColumnMetadata)cd, (long)timestamp, (ByteBuffer)this.valueType().serialize(entry.getValue()), (CellPath)CellPath.create((ByteBuffer)this.keyType().serialize(entry.getKey()))));
        }
    }
}

