/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCredentials;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsJMX
implements Serializable {
    public final String user;
    public final String password;

    public SettingsJMX(Options options, SettingsCredentials credentials) {
        this.user = options.user.setByUser() ? options.user.value() : credentials.jmxUsername;
        this.password = options.password.setByUser() ? options.password.value() : credentials.jmxPassword;
    }

    public void printSettings(ResultLogger out) {
        out.printf("  Username: %s%n", this.user);
        out.printf("  Password: %s%n", this.password == null ? "*not set*" : "*suppressed*");
    }

    public static SettingsJMX get(Map<String, String[]> clArgs, SettingsCredentials credentials) {
        String[] params = clArgs.remove("-jmx");
        if (params == null) {
            return new SettingsJMX(new Options(), credentials);
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsJMX.printHelp();
            System.out.println("Invalid -jmx options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsJMX((Options)options, credentials);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-jmx", new Options());
    }

    public static Runnable helpPrinter() {
        return SettingsJMX::printHelp;
    }

    public static final class Options
    extends GroupedOptions {
        final OptionSimple user = new OptionSimple("user=", ".*", null, String.format("Username for JMX connection, when specified, it will override the value in credentials file for key '%s'", "jmx.username"), false);
        final OptionSimple password = new OptionSimple("password=", ".*", null, String.format("Password for JMX connection, when specified, it will override the value in credentials file for key '%s'", "jmx.password"), false);

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.user, this.password);
        }
    }
}

