/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import com.addthis.metrics.reporter.config.AbstractMetricReporterConfig;
import com.addthis.metrics.reporter.config.HostPort;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHostPortReporterConfig
extends AbstractMetricReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractHostPortReporterConfig.class);
    public static final String MACRO_HOST_NAME = "host.name";
    public static final String MACRO_HOST_ADDRESS = "host.address";
    public static final String MACRO_HOST_FQDN = "host.fqdn";
    public static final String MACRO_HOST_NAME_SHORT = "host.name.short";
    @Valid
    private List<HostPort> hosts;
    @Valid
    private String hostsString;
    @NotNull
    private String prefix = "";
    private InetAddress localhost;
    private String resolvedPrefix;

    AbstractHostPortReporterConfig(InetAddress localhost) {
        this.localhost = localhost;
    }

    public AbstractHostPortReporterConfig() {
        try {
            this.localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.error("Unable to get localhost", (Throwable)e);
        }
    }

    public List<HostPort> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<HostPort> hosts) {
        this.hosts = hosts;
    }

    public String getHostsString() {
        return this.hostsString;
    }

    public void setHostsString(String hostsString) {
        this.hostsString = hostsString;
    }

    public String getResolvedPrefix() {
        return this.resolvedPrefix;
    }

    public List<HostPort> parseHostString() {
        ArrayList<HostPort> hosts = new ArrayList<HostPort>();
        String[] hostPairs = this.getHostsString().split(",");
        for (int i = 0; i < hostPairs.length; ++i) {
            String[] pair = hostPairs[i].split(":");
            hosts.add(new HostPort(pair[0], Integer.valueOf(pair[1])));
        }
        return hosts;
    }

    public List<HostPort> getHostListAndStringList() {
        if (this.getHosts() == null && this.getHostsString() == null) {
            log.warn("No hosts specified as a list or delimited string");
            return null;
        }
        if (this.getHosts() != null && this.getHostsString() != null) {
            log.warn("Did you really mean to have hosts as a list and delimited string?");
        }
        ArrayList<HostPort> combinedHosts = new ArrayList<HostPort>();
        if (this.getHosts() != null) {
            combinedHosts.addAll(this.getHosts());
        }
        if (this.getHostsString() != null) {
            combinedHosts.addAll(this.parseHostString());
        }
        return combinedHosts;
    }

    public abstract List<HostPort> getFullHostList();

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.resolvedPrefix = this.resolvePrefix(prefix);
    }

    private String sanitizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_-]", "_");
    }

    String resolvePrefix(String prefixTemplate) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (this.localhost != null) {
            String hostname = this.localhost.getHostName();
            valueMap.put(MACRO_HOST_NAME, this.sanitizeName(hostname));
            if (!StringUtils.isEmpty((CharSequence)hostname)) {
                valueMap.put(MACRO_HOST_NAME_SHORT, this.sanitizeName(StringUtils.split((String)hostname, (char)'.')[0]));
            }
            valueMap.put(MACRO_HOST_ADDRESS, this.sanitizeName(this.localhost.getHostAddress()));
            valueMap.put(MACRO_HOST_FQDN, this.sanitizeName(this.localhost.getCanonicalHostName()));
        }
        return StrSubstitutor.replace((Object)prefixTemplate, valueMap);
    }
}

