/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.FileChangeWatcher;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeWatcherTest
extends ZKTestCase {
    private static File tempDir;
    private static File tempFile;
    private static final Logger LOG;
    private static final long FS_TIMEOUT = 30000L;

    @BeforeAll
    public static void createTempFile() throws IOException {
        tempDir = ClientBase.createEmptyTestDir();
        tempFile = File.createTempFile("zk_test_", "", tempDir);
        tempFile.deleteOnExit();
    }

    @AfterAll
    public static void cleanupTempDir() {
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileChanges() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                    return;
                }
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            for (int i = 0; i < 3; ++i) {
                LOG.info("Modifying file, attempt {}", (Object)(i + 1));
                FileUtils.writeStringToFile((File)tempFile, (String)("Hello world " + i + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                ArrayList arrayList = events;
                synchronized (arrayList) {
                    if (events.size() < i + 1) {
                        events.wait(30000L);
                    }
                    Assertions.assertEquals((int)(i + 1), (int)events.size(), (String)"Wrong number of events");
                    WatchEvent event2 = (WatchEvent)events.get(i);
                    Assertions.assertEquals(StandardWatchEventKinds.ENTRY_MODIFY, event2.kind());
                    Assertions.assertEquals((Object)tempFile.getName(), (Object)event2.context().toString());
                    continue;
                }
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileTouched() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                    return;
                }
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            LOG.info("Touching file");
            FileUtils.touch((File)tempFile);
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.isEmpty()) {
                    events.wait(30000L);
                }
                Assertions.assertFalse((boolean)events.isEmpty());
                WatchEvent event2 = (WatchEvent)events.get(0);
                Assertions.assertEquals(StandardWatchEventKinds.ENTRY_MODIFY, event2.kind());
                Assertions.assertEquals((Object)tempFile.getName(), (Object)event2.context().toString());
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileAdded() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            File tempFile2 = File.createTempFile("zk_test_", "", tempDir);
            tempFile2.deleteOnExit();
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.isEmpty()) {
                    events.wait(30000L);
                }
                Assertions.assertFalse((boolean)events.isEmpty());
                WatchEvent event2 = (WatchEvent)events.get(0);
                Assertions.assertEquals(StandardWatchEventKinds.ENTRY_CREATE, event2.kind());
                Assertions.assertEquals((Object)tempFile2.getName(), (Object)event2.context().toString());
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileDeleted() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList events = new ArrayList();
            watcher = new FileChangeWatcher(tempDir.toPath(), event -> {
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                    return;
                }
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            tempFile.delete();
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.isEmpty()) {
                    events.wait(30000L);
                }
                Assertions.assertFalse((boolean)events.isEmpty());
                WatchEvent event2 = (WatchEvent)events.get(0);
                Assertions.assertEquals(StandardWatchEventKinds.ENTRY_DELETE, event2.kind());
                Assertions.assertEquals((Object)tempFile.getName(), (Object)event2.context().toString());
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackErrorDoesNotCrashWatcherThread() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            AtomicInteger callCount = new AtomicInteger(0);
            watcher = new FileChangeWatcher(tempDir.toPath(), event -> {
                int oldValue;
                LOG.info("Got an update: {} {}", event.kind(), event.context());
                AtomicInteger atomicInteger = callCount;
                synchronized (atomicInteger) {
                    oldValue = callCount.getAndIncrement();
                    callCount.notifyAll();
                }
                if (oldValue == 0) {
                    throw new RuntimeException("This error should not crash the watcher thread");
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            LOG.info("Modifying file");
            FileUtils.writeStringToFile((File)tempFile, (String)"Hello world\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
            AtomicInteger atomicInteger = callCount;
            synchronized (atomicInteger) {
                while (callCount.get() == 0) {
                    callCount.wait(30000L);
                }
            }
            LOG.info("Modifying file again");
            FileUtils.writeStringToFile((File)tempFile, (String)"Hello world again\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
            atomicInteger = callCount;
            synchronized (atomicInteger) {
                if (callCount.get() == 1) {
                    callCount.wait(30000L);
                }
            }
            Assertions.assertTrue((callCount.get() > 1 ? 1 : 0) != 0);
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(FileChangeWatcherTest.class);
    }
}

