/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.InetAddresses;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.EquivalentAddressGroup;
import io.grpc.internal.GrpcUtil;
import io.grpc.xds.Endpoints;
import io.grpc.xds.MetadataRegistry;
import io.grpc.xds.StructOrError;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.Endpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class XdsEndpointResource
extends XdsResourceType<EdsUpdate> {
    static final String ADS_TYPE_URL_EDS = "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment";
    public static final String GRPC_EXPERIMENTAL_XDS_DUALSTACK_ENDPOINTS = "GRPC_EXPERIMENTAL_XDS_DUALSTACK_ENDPOINTS";
    private static final XdsEndpointResource instance = new XdsEndpointResource();

    XdsEndpointResource() {
    }

    static XdsEndpointResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof ClusterLoadAssignment)) {
            return null;
        }
        return ((ClusterLoadAssignment)unpackedResource).getClusterName();
    }

    @Override
    public String typeName() {
        return "EDS";
    }

    @Override
    public String typeUrl() {
        return ADS_TYPE_URL_EDS;
    }

    @Override
    public boolean shouldRetrieveResourceKeysForArgs() {
        return true;
    }

    @Override
    protected boolean isFullStateOfTheWorld() {
        return false;
    }

    @Override
    protected Class<ClusterLoadAssignment> unpackedClassName() {
        return ClusterLoadAssignment.class;
    }

    @Override
    protected EdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage) throws XdsResourceType.ResourceInvalidException {
        if (!(unpackedMessage instanceof ClusterLoadAssignment)) {
            throw new XdsResourceType.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        return XdsEndpointResource.processClusterLoadAssignment((ClusterLoadAssignment)unpackedMessage);
    }

    private static boolean isEnabledXdsDualStack() {
        return GrpcUtil.getFlag((String)GRPC_EXPERIMENTAL_XDS_DUALSTACK_ENDPOINTS, (boolean)false);
    }

    private static EdsUpdate processClusterLoadAssignment(ClusterLoadAssignment assignment) throws XdsResourceType.ResourceInvalidException {
        HashMap priorities = new HashMap();
        LinkedHashMap<io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints>();
        ArrayList<Endpoints.DropOverload> dropOverloads = new ArrayList<Endpoints.DropOverload>();
        int maxPriority = -1;
        for (LocalityLbEndpoints localityLbEndpointsProto : assignment.getEndpointsList()) {
            StructOrError<Endpoints.LocalityLbEndpoints> structOrError = XdsEndpointResource.parseLocalityLbEndpoints(localityLbEndpointsProto);
            if (structOrError == null) continue;
            if (structOrError.getErrorDetail() != null) {
                throw new XdsResourceType.ResourceInvalidException(structOrError.getErrorDetail());
            }
            Endpoints.LocalityLbEndpoints localityLbEndpoints = structOrError.getStruct();
            int priority = localityLbEndpoints.priority();
            maxPriority = Math.max(maxPriority, priority);
            io.grpc.xds.client.Locality locality = XdsEndpointResource.parseLocality(localityLbEndpointsProto.getLocality());
            localityLbEndpointsMap.put(locality, localityLbEndpoints);
            if (!priorities.containsKey(priority)) {
                priorities.put(priority, new HashSet());
            }
            if (((Set)priorities.get(priority)).add(locality)) continue;
            throw new XdsResourceType.ResourceInvalidException("ClusterLoadAssignment has duplicate locality:" + locality + " for priority:" + priority);
        }
        if (priorities.size() != maxPriority + 1) {
            throw new XdsResourceType.ResourceInvalidException("ClusterLoadAssignment has sparse priorities");
        }
        for (ClusterLoadAssignment.Policy.DropOverload dropOverloadProto : assignment.getPolicy().getDropOverloadsList()) {
            dropOverloads.add(XdsEndpointResource.parseDropOverload(dropOverloadProto));
        }
        return new EdsUpdate(assignment.getClusterName(), localityLbEndpointsMap, dropOverloads);
    }

    private static io.grpc.xds.client.Locality parseLocality(Locality proto) {
        return io.grpc.xds.client.Locality.create(proto.getRegion(), proto.getZone(), proto.getSubZone());
    }

    private static Endpoints.DropOverload parseDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
        return Endpoints.DropOverload.create(proto.getCategory(), XdsEndpointResource.getRatePerMillion(proto.getDropPercentage()));
    }

    private static int getRatePerMillion(FractionalPercent percent) {
        int numerator = percent.getNumerator();
        FractionalPercent.DenominatorType type = percent.getDenominator();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
            case MILLION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown denominator type of " + percent);
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<Endpoints.LocalityLbEndpoints> parseLocalityLbEndpoints(LocalityLbEndpoints proto) throws XdsResourceType.ResourceInvalidException {
        ImmutableMap<String, Object> localityMetadata;
        if (!proto.hasLoadBalancingWeight() || proto.getLoadBalancingWeight().getValue() < 1) {
            return null;
        }
        if (proto.getPriority() < 0) {
            return StructOrError.fromError("negative priority");
        }
        MetadataRegistry registry = MetadataRegistry.getInstance();
        try {
            localityMetadata = registry.parseMetadata(proto.getMetadata());
        }
        catch (XdsResourceType.ResourceInvalidException e) {
            throw new XdsResourceType.ResourceInvalidException("Failed to parse Locality Endpoint metadata: " + e.getMessage(), e);
        }
        ArrayList<Endpoints.LbEndpoint> endpoints = new ArrayList<Endpoints.LbEndpoint>(proto.getLbEndpointsCount());
        for (LbEndpoint endpoint : proto.getLbEndpointsList()) {
            ImmutableMap<String, Object> endpointMetadata;
            if (!endpoint.hasEndpoint() || !endpoint.getEndpoint().hasAddress()) {
                return StructOrError.fromError("LbEndpoint with no endpoint/address");
            }
            try {
                endpointMetadata = registry.parseMetadata(endpoint.getMetadata());
            }
            catch (XdsResourceType.ResourceInvalidException e) {
                throw new XdsResourceType.ResourceInvalidException("Failed to parse Endpoint metadata: " + e.getMessage(), e);
            }
            ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
            addresses.add(XdsEndpointResource.getInetSocketAddress(endpoint.getEndpoint().getAddress()));
            if (XdsEndpointResource.isEnabledXdsDualStack()) {
                for (Endpoint.AdditionalAddress additionalAddress : endpoint.getEndpoint().getAdditionalAddressesList()) {
                    addresses.add(XdsEndpointResource.getInetSocketAddress(additionalAddress.getAddress()));
                }
            }
            boolean isHealthy = endpoint.getHealthStatus() == HealthStatus.HEALTHY || endpoint.getHealthStatus() == HealthStatus.UNKNOWN;
            endpoints.add(Endpoints.LbEndpoint.create(new EquivalentAddressGroup(addresses), endpoint.getLoadBalancingWeight().getValue(), isHealthy, endpoint.getEndpoint().getHostname(), endpointMetadata));
        }
        return StructOrError.fromStruct(Endpoints.LocalityLbEndpoints.create(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority(), localityMetadata));
    }

    private static InetSocketAddress getInetSocketAddress(Address address) {
        SocketAddress socketAddress = address.getSocketAddress();
        return new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
    }

    public static class AddressMetadataParser
    implements MetadataRegistry.MetadataValueParser {
        @Override
        public String getTypeUrl() {
            return "type.googleapis.com/envoy.config.core.v3.Address";
        }

        @Override
        public java.net.SocketAddress parse(Any any) throws XdsResourceType.ResourceInvalidException {
            SocketAddress socketAddress;
            try {
                socketAddress = ((Address)any.unpack(Address.class)).getSocketAddress();
            }
            catch (InvalidProtocolBufferException ex) {
                throw new XdsResourceType.ResourceInvalidException("Invalid Resource in address proto", ex);
            }
            this.validateAddress(socketAddress);
            String ip = socketAddress.getAddress();
            int port = socketAddress.getPortValue();
            try {
                return new InetSocketAddress(InetAddresses.forString((String)ip), port);
            }
            catch (IllegalArgumentException e) {
                throw this.createException("Invalid IP address or port: " + ip + ":" + port);
            }
        }

        private void validateAddress(SocketAddress socketAddress) throws XdsResourceType.ResourceInvalidException {
            if (socketAddress.getAddress().isEmpty()) {
                throw this.createException("Address field is empty or invalid.");
            }
            long port = Integer.toUnsignedLong(socketAddress.getPortValue());
            if (port > 65535L) {
                throw this.createException(String.format("Port value %d out of range 1-65535.", port));
            }
        }

        private XdsResourceType.ResourceInvalidException createException(String message) {
            return new XdsResourceType.ResourceInvalidException("Failed to parse envoy.config.core.v3.Address: " + message);
        }
    }

    static final class EdsUpdate
    implements XdsClient.ResourceUpdate {
        final String clusterName;
        final Map<io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap;
        final List<Endpoints.DropOverload> dropPolicies;

        EdsUpdate(String clusterName, Map<io.grpc.xds.client.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints, List<Endpoints.DropOverload> dropPolicies) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.localityLbEndpointsMap = Collections.unmodifiableMap(new LinkedHashMap((Map)Preconditions.checkNotNull(localityLbEndpoints, (Object)"localityLbEndpoints")));
            this.dropPolicies = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(dropPolicies, (Object)"dropPolicies")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsUpdate that = (EdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.localityLbEndpointsMap, that.localityLbEndpointsMap) && Objects.equals(this.dropPolicies, that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }
    }
}

