/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;

public class RoleAnnotationHandler
extends AuthorizingAnnotationHandler {
    public RoleAnnotationHandler() {
        super(RequiresRoles.class);
    }

    @Override
    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresRoles)) {
            return;
        }
        RequiresRoles rrAnnotation = (RequiresRoles)a;
        String[] roles = rrAnnotation.value();
        if (roles.length == 1) {
            this.getSubject().checkRole(roles[0]);
            return;
        }
        if (Logical.AND.equals((Object)rrAnnotation.logical())) {
            this.getSubject().checkRoles(Arrays.asList(roles));
            return;
        }
        if (Logical.OR.equals((Object)rrAnnotation.logical())) {
            boolean hasAtLeastOneRole = false;
            for (String role : roles) {
                if (!this.getSubject().hasRole(role)) continue;
                hasAtLeastOneRole = true;
            }
            if (!hasAtLeastOneRole) {
                this.getSubject().checkRole(roles[0]);
            }
        }
    }
}

