/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef NSDEFS_H
#define NSDEFS_H

#include <windows.h>

#ifdef _DEBUG
  #define BREAK_TO_DEBUGGER           DebugBreak()
#else   
  #define BREAK_TO_DEBUGGER
#endif  

#ifdef _DEBUG
  #define VERIFY(exp)                 if (!(exp)) { GetLastError(); BREAK_TO_DEBUGGER; }
#else   // !_DEBUG
  #define VERIFY(exp)                 (exp)
#endif  // !_DEBUG

// NSPR Win32 modules:
// nsWindow, nsSound, and nsClipboard
//
// Logging can be changed at runtime without recompiling in the General
// property page of Visual Studio under the "Environment" property.
//
// Two variables are of importance to be set: 
// NSPR_LOG_MODULES and NSPR_LOG_FILE
//
// NSPR_LOG_MODULES:
// NSPR_LOG_MODULES=all:5         (To log everything completely)
// NSPR_LOG_MODULES=nsWindow:5,nsSound:5,nsClipboard:5 
//                                (To log windows widget stuff)
// NSPR_LOG_MODULES=              (To turn off logging)
//
// NSPR_LOG_FILE:
// NSPR_LOG_FILE=C:\nsprlog.txt   (To a file on disk)
// NSPR_LOG_FILE=WinDebug         (To the debug window)
// NSPR_LOG_FILE=                 (To stdout/stderr)

#endif  // NSDEFS_H


