/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.ui;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.AbstractChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.FList;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/PresentableChangeNode;", "Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;", "presentableChange", "activityMatcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;Lcom/intellij/psi/codeStyle/MinusculeMatcher;)V", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "userObject", "render", "", "tree", "Ljavax/swing/JTree;", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.platform.lvcs.impl"})
class PresentableChangeNode
extends AbstractChangesBrowserFilePathNode<PresentableChange> {
    @Nullable
    private final MinusculeMatcher activityMatcher;

    public PresentableChangeNode(@NotNull PresentableChange presentableChange, @Nullable MinusculeMatcher activityMatcher) {
        Intrinsics.checkNotNullParameter((Object)presentableChange, (String)"presentableChange");
        super((Object)presentableChange, presentableChange.getFileStatus());
        this.activityMatcher = activityMatcher;
    }

    @NotNull
    protected FilePath filePath(@NotNull PresentableChange userObject) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        FilePath filePath = userObject.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }

    public void render(@NotNull JTree tree, @NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        SpeedSearchSupply speedSearch;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        super.render(tree, renderer, selected, expanded, hasFocus);
        SpeedSearchSupply speedSearchSupply = speedSearch = TreeSpeedSearch.getSupply((JComponent)tree);
        if (!(speedSearchSupply != null ? speedSearchSupply.isPopupActive() : false)) {
            MinusculeMatcher minusculeMatcher = this.activityMatcher;
            FList matchedFragments = minusculeMatcher != null ? minusculeMatcher.matchingFragments(((Object)renderer.getCharSequence(true)).toString()) : null;
            SpeedSearchUtil.applySpeedSearchHighlighting((SimpleColoredComponent)((SimpleColoredComponent)renderer), (Iterable)((Iterable)matchedFragments), (boolean)selected);
        }
    }
}

