/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.eel.provider.utils.EelProcessExecutionResultInfo;
import com.intellij.platform.eel.provider.utils.EelProcessUtilsKt;
import com.intellij.python.processOutput.ProcessOutputApi;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.errorProcessing.ExecErrorImpl;
import com.jetbrains.python.errorProcessing.ExecErrorReason;
import com.jetbrains.python.errorProcessing.MessageError;
import com.jetbrains.python.errorProcessing.PyError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\"\u0010\u0006\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\bH\u0007\u001a3\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"showErrorDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "execError", "Lcom/jetbrains/python/errorProcessing/PyError;", "showProcessExecutionErrorDialog", "Lcom/jetbrains/python/errorProcessing/ExecErrorImpl;", "Lcom/jetbrains/python/errorProcessing/ExecError;", "appendProcessOutput", "Ljavax/swing/JTextPane;", "command", "", "stdout", "stderr", "exitCode", "", "(Ljavax/swing/JTextPane;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nProcessExecutionErrorDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessExecutionErrorDialog.kt\ncom/jetbrains/python/ProcessExecutionErrorDialogKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,146:1\n13805#2,2:147\n*S KotlinDebug\n*F\n+ 1 ProcessExecutionErrorDialog.kt\ncom/jetbrains/python/ProcessExecutionErrorDialogKt\n*L\n139#1:147,2\n*E\n"})
public final class ProcessExecutionErrorDialogKt {
    @ApiStatus.Internal
    @RequiresEdt
    public static final void showErrorDialog(@Nullable Project project, @NotNull PyError execError) {
        Intrinsics.checkNotNullParameter((Object)execError, (String)"execError");
        PyError pyError = execError;
        if (pyError instanceof ExecErrorImpl) {
            ProcessExecutionErrorDialogKt.showProcessExecutionErrorDialog(project, (ExecErrorImpl)execError);
        } else if (pyError instanceof MessageError) {
            Messages.showErrorDialog((String)execError.getMessage(), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @RequiresEdt
    public static final void showProcessExecutionErrorDialog(@Nullable Project project, @NotNull ExecErrorImpl<?> execError) {
        void $this$showProcessExecutionErrorDialog_u24lambda_u243;
        JTextPane jTextPane2;
        Intrinsics.checkNotNullParameter(execError, (String)"execError");
        if (!(project == null || !project.isDisposed())) {
            throw new IllegalStateException("Check failed.");
        }
        Integer logId = execError.getLoggedProcessId();
        if (project != null && logId != null) {
            ProcessOutputApi processOutputApi = ProcessOutputApi.Companion.getInstance();
            if (processOutputApi != null) {
                ProcessOutputApi processOutputApi2;
                ProcessOutputApi api = processOutputApi2 = processOutputApi;
                boolean jTextPane2 = false;
                boolean foundAndOpened = api.tryOpenLogInToolWindow(project, logId.intValue());
                if (foundAndOpened) {
                    String string = execError.getAdditionalMessageToUser();
                    if (string != null) {
                        String string2;
                        String it = string2 = string;
                        boolean bl = false;
                        api.specifyAdditionalMessageToUser(project, logId.intValue(), it);
                    }
                    return;
                }
            }
        }
        String string = PyBundle.message("dialog.message.command.could.not.complete", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String errorMessageText = string;
        JBLabel errorMessageLabel = new JBLabel(UIUtil.toHtml((String)errorMessageText), Messages.getErrorIcon(), 2);
        JTextPane $this$showProcessExecutionErrorDialog_u24lambda_u241 = jTextPane2 = new JTextPane();
        boolean bl = false;
        String command = execError.getAsCommand();
        Object err = execError.getErrorReason();
        if (err instanceof ExecErrorReason.CantStart) {
            ProcessExecutionErrorDialogKt.appendProcessOutput($this$showProcessExecutionErrorDialog_u24lambda_u241, command, ((ExecErrorReason.CantStart)err).getCantExecProcessError(), execError.getMessage(), null);
        } else if (err instanceof ExecErrorReason.UnexpectedProcessTermination) {
            ProcessExecutionErrorDialogKt.appendProcessOutput($this$showProcessExecutionErrorDialog_u24lambda_u241, command, EelProcessUtilsKt.getStdoutString((EelProcessExecutionResultInfo)((EelProcessExecutionResultInfo)err)), EelProcessUtilsKt.getStderrString((EelProcessExecutionResultInfo)((EelProcessExecutionResultInfo)err)), ((ExecErrorReason.UnexpectedProcessTermination)err).getExitCode());
        } else if (Intrinsics.areEqual((Object)err, (Object)ExecErrorReason.Timeout.INSTANCE)) {
            ProcessExecutionErrorDialogKt.appendProcessOutput($this$showProcessExecutionErrorDialog_u24lambda_u241, command, "Timeout", "\n", null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$showProcessExecutionErrorDialog_u24lambda_u241.setBackground((Color)JBColor.WHITE);
        $this$showProcessExecutionErrorDialog_u24lambda_u241.setEditable(false);
        JTextPane commandOutputTextPane = jTextPane2;
        JTextPane $this$showProcessExecutionErrorDialog_u24lambda_u242 = $this$showProcessExecutionErrorDialog_u24lambda_u241 = new BorderLayoutPanel();
        boolean bl2 = false;
        $this$showProcessExecutionErrorDialog_u24lambda_u242.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"border.title.command.output", (Object[])new Object[0]), (boolean)false));
        $this$showProcessExecutionErrorDialog_u24lambda_u242.addToCenter((Component)new JBScrollPane((Component)commandOutputTextPane, 20, 31));
        JTextPane commandOutputPanel = $this$showProcessExecutionErrorDialog_u24lambda_u241;
        JButton jButton = new JButton(PyBundle.message("python.error.full.log", new Object[0]));
        err = jButton;
        FormBuilder formBuilder = new FormBuilder().addComponent((JComponent)errorMessageLabel);
        boolean bl3 = false;
        $this$showProcessExecutionErrorDialog_u24lambda_u243.addActionListener(arg_0 -> ProcessExecutionErrorDialogKt.showProcessExecutionErrorDialog$lambda$3$0(execError, arg_0));
        FormBuilder formBuilder2 = formBuilder.addComponent((JComponent)jButton).addComponentFillVertically((JComponent)commandOutputPanel, 4);
        Intrinsics.checkNotNullExpressionValue((Object)formBuilder2, (String)"addComponentFillVertically(...)");
        FormBuilder formBuilder3 = formBuilder2;
        new DialogWrapper(execError, errorMessageText, project, formBuilder3){
            final /* synthetic */ FormBuilder $formBuilder;
            {
                this.$formBuilder = $formBuilder;
                super($project);
                this.init();
                String string = $execError.getAdditionalMessageToUser();
                if (string == null) {
                    string = $errorMessageText;
                }
                this.setTitle(string);
            }

            protected Action[] createActions() {
                Action[] actionArray = new Action[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
                return actionArray;
            }

            protected JComponent createCenterPanel() {
                JPanel jPanel;
                JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = this.$formBuilder.getPanel();
                boolean bl = false;
                $this$createCenterPanel_u24lambda_u240.setPreferredSize(new Dimension(820, 400));
                JPanel jPanel2 = jPanel;
                Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"apply(...)");
                return jPanel2;
            }
        }.showAndGet();
    }

    private static final void appendProcessOutput(JTextPane $this$appendProcessOutput, String command, String stdout, String stderr, Integer exitCode) {
        Document document;
        Style stdoutStyle = $this$appendProcessOutput.addStyle(null, null);
        StyleConstants.setFontFamily(stdoutStyle, "Monospaced");
        Style stderrStyle = $this$appendProcessOutput.addStyle(null, stdoutStyle);
        StyleConstants.setForeground(stderrStyle, (Color)JBColor.RED);
        Document $this$appendProcessOutput_u24lambda_u240 = document = $this$appendProcessOutput.getDocument();
        boolean bl = false;
        $this$appendProcessOutput_u24lambda_u240.insertString(0, command + "\n", stdoutStyle);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)stdout, (Object)stdoutStyle), TuplesKt.to((Object)stderr, (Object)stderrStyle)};
        Pair[] $this$forEach$iv = pairArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair element$iv;
            Pair pair = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String std = (String)pair.component1();
            Style style = (Style)pair.component2();
            if (!(((CharSequence)std).length() > 0)) continue;
            $this$appendProcessOutput_u24lambda_u240.insertString($this$appendProcessOutput_u24lambda_u240.getLength(), std + "\n", style);
        }
        if (exitCode != null) {
            $this$appendProcessOutput_u24lambda_u240.insertString($this$appendProcessOutput_u24lambda_u240.getLength(), "Process finished with exit code " + exitCode, stdoutStyle);
        }
    }

    private static final void showProcessExecutionErrorDialog$lambda$3$0(ExecErrorImpl $execError, ActionEvent it) {
        Messages.showErrorDialog((String)$execError.getMessage(), (String)PyBundle.message("python.error", new Object[0]));
    }
}

