/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelUtil;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.color.SelectionColorLayer;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ResultViewWithCells {
    public boolean isCellEditingAllowed();

    public void editSelectedCell();

    @Nullable
    public TableCellEditor getCellEditor();

    @Nullable
    public Color getCellBackground(@NotNull ViewIndex<GridRow> var1, @NotNull ViewIndex<GridColumn> var2, boolean var3);

    @NotNull
    public Color getCellForeground(boolean var1);

    @NotNull
    public static Component prepareComponent(@NotNull Component component, @NotNull DataGrid grid, @NotNull ResultViewWithCells resultView, @NotNull ViewIndex<GridRow> row, @NotNull ViewIndex<GridColumn> column, boolean forDisplay) {
        if (component == null) {
            ResultViewWithCells.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            ResultViewWithCells.$$$reportNull$$$0(1);
        }
        if (resultView == null) {
            ResultViewWithCells.$$$reportNull$$$0(2);
        }
        if (row == null) {
            ResultViewWithCells.$$$reportNull$$$0(3);
        }
        if (column == null) {
            ResultViewWithCells.$$$reportNull$$$0(4);
        }
        if (!forDisplay) {
            Component component2 = component;
            if (component2 == null) {
                ResultViewWithCells.$$$reportNull$$$0(5);
            }
            return component2;
        }
        JComponent unwrapped = (JComponent)ExpandedItemRendererComponentWrapper.unwrap((Component)component);
        SelectionModel selectionModel = SelectionModelUtil.get(grid, (ResultView)((Object)resultView));
        boolean selected = selectionModel.isSelected(row, column);
        Color background = resultView.getCellBackground(row, column, selected);
        Color foreground = resultView.getCellForeground(selected);
        if (background != null) {
            unwrapped.setBackground(background);
        } else if (!SelectionColorLayer.isRowBgPaintedByTable(grid.getResultView().isTransposed() ? column : row, grid, selected)) {
            unwrapped.setBackground(((ResultView)((Object)resultView)).getComponent().getBackground());
        }
        unwrapped.setForeground(foreground);
        unwrapped.setOpaque(!Comparing.equal((Object)unwrapped.getBackground(), (Object)((ResultView)((Object)resultView)).getComponent().getBackground()));
        if (unwrapped instanceof CellRendererPanel) {
            ((CellRendererPanel)unwrapped).setSelected(!Comparing.equal((Object)background, (Object)((ResultView)((Object)resultView)).getComponent().getBackground()));
        }
        Component component3 = component;
        if (component3 == null) {
            ResultViewWithCells.$$$reportNull$$$0(6);
        }
        return component3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/ResultViewWithCells";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/ResultViewWithCells";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareComponent";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

