/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.ExplicitOperatorBinding;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.ExplicitReturnTypeInference;
import org.apache.calcite.sql.type.MatchReturnTypeInference;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.OrdinalReturnTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInferenceChain;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransformCascade;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ReturnTypes {
    public static final SqlReturnTypeInference ARG0 = new OrdinalReturnTypeInference(0);
    public static final SqlReturnTypeInference ARG0_NULLABLE_VARYING = ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING);
    public static final SqlReturnTypeInference ARG0_NULLABLE = ARG0.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_ARRAY_NULLABLE_VARYING = opBinding -> {
        SqlTypeName op = opBinding.getOperandType(0).getSqlTypeName();
        if (op == SqlTypeName.ARRAY) {
            return ARG0_NULLABLE.inferReturnType(opBinding);
        }
        return ARG0_NULLABLE_VARYING.inferReturnType(opBinding);
    };
    public static final SqlReturnTypeInference ARG0_NULLABLE_IF_ARG0_NULLABLE = ARG0.andThen(SqlTypeTransforms.ARG0_NULLABLE);
    public static final SqlReturnTypeInference ARG0_FORCE_NULLABLE = ARG0.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference ARG0_INTERVAL = new MatchReturnTypeInference(0, SqlTypeFamily.DATETIME_INTERVAL.getTypeNames());
    public static final SqlReturnTypeInference ARG0_INTERVAL_NULLABLE = ARG0_INTERVAL.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_NULLABLE_IF_EMPTY = new OrdinalReturnTypeInference(0){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type = super.inferReturnType(opBinding);
            if (opBinding.hasEmptyGroup() || opBinding.hasFilter()) {
                return opBinding.getTypeFactory().createTypeWithNullability(type, true);
            }
            return type;
        }
    };
    public static final SqlReturnTypeInference ARG1 = new OrdinalReturnTypeInference(1);
    public static final SqlReturnTypeInference ARG1_NULLABLE = ARG1.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG2 = new OrdinalReturnTypeInference(2);
    public static final SqlReturnTypeInference ARG2_NULLABLE = ARG2.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN = ReturnTypes.explicit(SqlTypeName.BOOLEAN);
    public static final SqlReturnTypeInference BOOLEAN_NULLABLE = BOOLEAN.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN_NULLABLE_IF_ARG0_NULLABLE = BOOLEAN.andThen(SqlTypeTransforms.ARG0_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN_NULLABLE_OPTIMIZED = opBinding -> {
        int n = opBinding.getOperandCount();
        RelDataType type1 = null;
        for (int i = 0; i < n && !(type1 = opBinding.getOperandType(i)).isNullable(); ++i) {
        }
        return type1;
    };
    public static final SqlReturnTypeInference BOOLEAN_FORCE_NULLABLE = BOOLEAN.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN_NOT_NULL = BOOLEAN.andThen(SqlTypeTransforms.TO_NOT_NULLABLE);
    public static final SqlReturnTypeInference DATE = ReturnTypes.explicit(SqlTypeName.DATE);
    public static final SqlReturnTypeInference DATE_NULLABLE = DATE.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_EXCEPT_DATE = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        SqlTypeName op = opBinding.getOperandType(0).getSqlTypeName();
        switch (op) {
            case DATE: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
        }
        return typeFactory.createSqlType(op);
    };
    public static final SqlReturnTypeInference ARG0_EXCEPT_DATE_NULLABLE = ARG0_EXCEPT_DATE.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TIME = ReturnTypes.explicit(SqlTypeName.TIME, 0);
    public static final SqlReturnTypeInference TIME_NULLABLE = TIME.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TIMESTAMP = ReturnTypes.explicit(SqlTypeName.TIMESTAMP);
    public static final SqlReturnTypeInference TIMESTAMP_NULLABLE = TIMESTAMP.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TIMESTAMP_LTZ = ReturnTypes.explicit(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    public static final SqlReturnTypeInference TIMESTAMP_TZ = ReturnTypes.explicit(SqlTypeName.TIMESTAMP_TZ);
    public static final SqlReturnTypeInference TIMESTAMP_LTZ_NULLABLE = TIMESTAMP_LTZ.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TIMESTAMP_TZ_NULLABLE = TIMESTAMP_TZ.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference DOUBLE = ReturnTypes.explicit(SqlTypeName.DOUBLE);
    public static final SqlReturnTypeInference DOUBLE_NULLABLE = DOUBLE.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference DOUBLE_FORCE_NULLABLE = DOUBLE.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference CHAR = ReturnTypes.explicit(SqlTypeName.CHAR);
    public static final SqlReturnTypeInference CHAR_FORCE_NULLABLE = CHAR.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference CHAR_NULLABLE_IF_ARGS_NULLABLE = CHAR.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TINYINT = ReturnTypes.explicit(SqlTypeName.TINYINT);
    public static final SqlReturnTypeInference TINYINT_NULLABLE = TINYINT.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference INTEGER = ReturnTypes.explicit(SqlTypeName.INTEGER);
    public static final SqlReturnTypeInference INTEGER_NULLABLE = INTEGER.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BIGINT = ReturnTypes.explicit(SqlTypeName.BIGINT);
    public static final SqlReturnTypeInference BIGINT_FORCE_NULLABLE = BIGINT.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference BIGINT_NULLABLE = BIGINT.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference VARCHAR_4 = ReturnTypes.explicit(SqlTypeName.VARCHAR, 4);
    public static final SqlReturnTypeInference VARCHAR_4_NULLABLE = VARCHAR_4.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference VARCHAR_2000 = ReturnTypes.explicit(SqlTypeName.VARCHAR, 2000);
    public static final SqlReturnTypeInference VARCHAR_2000_NULLABLE = VARCHAR_2000.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference VARCHAR = ReturnTypes.explicit(SqlTypeName.VARCHAR);
    public static final SqlReturnTypeInference VARIANT = ReturnTypes.explicit(SqlTypeName.VARIANT);
    public static final SqlReturnTypeInference VARCHAR_NULLABLE = VARCHAR.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference VARCHAR_FORCE_NULLABLE = VARCHAR.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference VARBINARY = ReturnTypes.explicit(SqlTypeName.VARBINARY);
    public static final SqlReturnTypeInference VARBINARY_NULLABLE = VARBINARY.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference VARBINARY_FORCE_NULLABLE = VARBINARY.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference HISTOGRAM = ReturnTypes.explicit(SqlTypeName.VARBINARY, 8);
    public static final SqlReturnTypeInference CURSOR = ReturnTypes.explicit(SqlTypeName.CURSOR);
    public static final SqlReturnTypeInference COLUMN_LIST = ReturnTypes.explicit(SqlTypeName.COLUMN_LIST);
    public static final SqlReturnTypeInference LEAST_RESTRICTIVE = ReturnTypes.andThen(SqlTypeTransforms.FROM_MEASURE_IF::apply, ReturnTypes::leastRestrictive);
    public static final SqlReturnTypeInference NVL2_RESTRICTIVE = opBinding -> opBinding.getTypeFactory().leastRestrictive(Arrays.asList(opBinding.getOperandType(1), opBinding.getOperandType(2)));
    public static final SqlReturnTypeInference ARG0_EXCEPT_INTEGER = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType opType = opBinding.getOperandType(0);
        if (SqlTypeName.INT_TYPES.contains((Object)opType.getSqlTypeName())) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), false);
        }
        return opType;
    };
    public static final SqlReturnTypeInference ARG0_EXCEPT_INTEGER_NULLABLE = ARG0_EXCEPT_INTEGER.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_OR_INTEGER = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        if (SqlTypeName.NULL == opBinding.getOperandType(0).getSqlTypeName()) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true);
        }
        return opBinding.getOperandType(0);
    };
    public static final SqlReturnTypeInference LARGEST_INT_OR_FIRST_NON_NULL = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType largestIntegerType = null;
        RelDataType firstNonNullType = null;
        boolean allArgsInteger = true;
        boolean nullable = false;
        for (RelDataType opType : opBinding.collectOperandTypes()) {
            if (firstNonNullType == null && SqlTypeName.NULL != opType.getSqlTypeName()) {
                firstNonNullType = opType;
            }
            if (SqlTypeName.INT_TYPES.contains((Object)opType.getSqlTypeName()) && (largestIntegerType == null || largestIntegerType.getPrecision() < opType.getPrecision())) {
                largestIntegerType = opType;
            } else {
                allArgsInteger = false;
            }
            nullable |= opType.isNullable();
        }
        if (allArgsInteger && largestIntegerType != null) {
            return typeFactory.createTypeWithNullability(largestIntegerType, nullable);
        }
        if (firstNonNullType != null) {
            return typeFactory.createTypeWithNullability(firstNonNullType, nullable);
        }
        throw opBinding.newError(Static.RESOURCE.atLeastOneArgumentMustNotBeNull(opBinding.getOperator().getName()));
    };
    public static final SqlReturnTypeInference MULTISET = opBinding -> {
        ExplicitOperatorBinding newBinding = new ExplicitOperatorBinding(opBinding, (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                RelDataType type = opBinding.getOperandType(index).getComponentType();
                if (type == null) {
                    return opBinding.getTypeFactory().createSqlType(SqlTypeName.NULL);
                }
                return type;
            }

            @Override
            public int size() {
                return opBinding.getOperandCount();
            }
        });
        RelDataType biggestElementType = LEAST_RESTRICTIVE.inferReturnType(newBinding);
        return opBinding.getTypeFactory().createMultisetType(Objects.requireNonNull(biggestElementType, () -> "can't infer element type for multiset of " + newBinding), -1L);
    };
    public static final SqlReturnTypeInference TO_COLLECTION_ELEMENT = ARG0.andThen(SqlTypeTransforms.TO_COLLECTION_ELEMENT_TYPE);
    public static final SqlReturnTypeInference TO_COLLECTION_ELEMENT_NULLABLE = TO_COLLECTION_ELEMENT.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TO_COLLECTION_ELEMENT_FORCE_NULLABLE = TO_COLLECTION_ELEMENT.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference TO_MULTISET = ARG0.andThen(SqlTypeTransforms.TO_MULTISET);
    public static final SqlReturnTypeInference MULTISET_ELEMENT_FORCE_NULLABLE = MULTISET.andThen(SqlTypeTransforms.TO_COLLECTION_ELEMENT_TYPE).andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference MULTISET_NULLABLE = MULTISET.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference MULTISET_PROJECT_ONLY = MULTISET.andThen(SqlTypeTransforms.ONLY_COLUMN);
    public static final SqlReturnTypeInference TO_ARRAY = ARG0.andThen(SqlTypeTransforms.TO_ARRAY);
    public static final SqlReturnTypeInference TO_ARRAY_NULLABLE = TO_ARRAY.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TO_MAP = ARG0.andThen(SqlTypeTransforms.TO_MAP);
    public static final SqlReturnTypeInference IDENTITY_TO_MAP = ARG0.andThen(SqlTypeTransforms.IDENTITY_TO_MAP);
    public static final SqlReturnTypeInference IDENTITY_TO_MAP_NULLABLE = IDENTITY_TO_MAP.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TO_ROW = ARG0.andThen(SqlTypeTransforms.TO_ROW);
    public static final SqlReturnTypeInference TO_MAP_ENTRIES = TO_ROW.andThen(SqlTypeTransforms.TO_ARRAY);
    public static final SqlReturnTypeInference TO_MAP_ENTRIES_NULLABLE = TO_MAP_ENTRIES.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TO_MAP_KEYS = ARG0.andThen(SqlTypeTransforms.TO_MAP_KEYS);
    public static final SqlReturnTypeInference TO_MAP_KEYS_NULLABLE = TO_MAP_KEYS.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference TO_MAP_VALUES = ARG0.andThen(SqlTypeTransforms.TO_MAP_VALUES);
    public static final SqlReturnTypeInference TO_MAP_VALUES_NULLABLE = TO_MAP_VALUES.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference GEOMETRY = ReturnTypes.explicit(SqlTypeName.GEOMETRY);
    public static final SqlReturnTypeInference INTEGER_QUOTIENT_NULLABLE = ARG0_INTERVAL_NULLABLE.orElse(LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_SCALE0 = opBinding -> {
        RelDataType type1 = opBinding.getOperandType(0);
        if (SqlTypeUtil.isDecimal(type1)) {
            if (type1.getScale() == 0) {
                return type1;
            }
            int p = type1.getPrecision();
            RelDataType ret = opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, p, 0);
            if (type1.isNullable()) {
                ret = opBinding.getTypeFactory().createTypeWithNullability(ret, true);
            }
            return ret;
        }
        return null;
    };
    public static final SqlReturnTypeInference DECIMAL_OR_DOUBLE = opBinding -> {
        boolean haveDecimal = false;
        for (int i = 0; i < opBinding.getOperandCount(); ++i) {
            if (!SqlTypeUtil.isDecimal(opBinding.getOperandType(i))) continue;
            haveDecimal = true;
            break;
        }
        if (haveDecimal) {
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, 17);
        }
        return (RelDataType)RelDataTypeImpl.proto(SqlTypeName.DOUBLE, false).apply(opBinding.getTypeFactory());
    };
    public static final SqlReturnTypeInference DECIMAL_OR_DOUBLE_NULLABLE = DECIMAL_OR_DOUBLE.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_OR_EXACT_NO_SCALE = DECIMAL_SCALE0.orElse(ARG0);
    public static final SqlReturnTypeInference DECIMAL_PRODUCT = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        return typeFactory.getTypeSystem().deriveDecimalMultiplyType(typeFactory, type1, type2);
    };
    public static final SqlReturnTypeInference DECIMAL_PRODUCT_NULLABLE = DECIMAL_PRODUCT.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference PRODUCT_FORCE_NULLABLE = DECIMAL_PRODUCT_NULLABLE.orElse(LEAST_RESTRICTIVE).andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference PRODUCT_NULLABLE = DECIMAL_PRODUCT_NULLABLE.orElse(ARG0_INTERVAL_NULLABLE).orElse(LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_QUOTIENT = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        return typeFactory.getTypeSystem().deriveDecimalDivideType(typeFactory, type1, type2);
    };
    public static final SqlReturnTypeInference DECIMAL_QUOTIENT_NULLABLE = DECIMAL_QUOTIENT.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference DOUBLE_IF_INTEGERS = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        SqlTypeName type1 = opBinding.getOperandType(0).getSqlTypeName();
        SqlTypeName type2 = opBinding.getOperandType(1).getSqlTypeName();
        boolean isInts = SqlTypeName.INT_TYPES.contains((Object)type1) && SqlTypeName.INT_TYPES.contains((Object)type2);
        return isInts ? typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true) : null;
    };
    public static final SqlReturnTypeInference QUOTIENT_FORCE_NULLABLE = DECIMAL_QUOTIENT_NULLABLE.orElse(LEAST_RESTRICTIVE).andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference QUOTIENT_NULLABLE = DECIMAL_QUOTIENT_NULLABLE.orElse(ARG0_INTERVAL_NULLABLE).orElse(LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_SUM = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        return typeFactory.getTypeSystem().deriveDecimalPlusType(typeFactory, type1, type2);
    };
    public static final SqlReturnTypeInference DECIMAL_SUM_NULLABLE = DECIMAL_SUM.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference SUM_FORCE_NULLABLE = DECIMAL_SUM_NULLABLE.orElse(LEAST_RESTRICTIVE).andThen(SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference NULLABLE_SUM = new SqlReturnTypeInferenceChain(DECIMAL_SUM_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_MOD = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        return typeFactory.getTypeSystem().deriveDecimalModType(typeFactory, type1, type2);
    };
    public static final SqlReturnTypeInference DECIMAL_MOD_NULLABLE = DECIMAL_MOD.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference NULLABLE_MOD = DECIMAL_MOD_NULLABLE.orElse(ARG1_NULLABLE);
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION = opBinding -> {
        boolean containsNullType;
        RelDataType argType0 = opBinding.getOperandType(0);
        RelDataType argType1 = opBinding.getOperandType(1);
        boolean containsAnyType = argType0.getSqlTypeName() == SqlTypeName.ANY || argType1.getSqlTypeName() == SqlTypeName.ANY;
        boolean bl = containsNullType = argType0.getSqlTypeName() == SqlTypeName.NULL || argType1.getSqlTypeName() == SqlTypeName.NULL;
        if (!(containsAnyType || containsNullType || SqlTypeUtil.inCharOrBinaryFamilies(argType0) && SqlTypeUtil.inCharOrBinaryFamilies(argType1))) {
            Preconditions.checkArgument((boolean)SqlTypeUtil.sameNamedType(argType0, argType1));
        }
        SqlCollation pickedCollation = null;
        if (!containsAnyType && !containsNullType && SqlTypeUtil.inCharFamily(argType0)) {
            if (!SqlTypeUtil.isCharTypeComparable(opBinding.collectOperandTypes().subList(0, 2))) {
                throw opBinding.newError(Static.RESOURCE.typeNotComparable(argType0.getFullTypeString(), argType1.getFullTypeString()));
            }
            pickedCollation = Objects.requireNonNull(SqlCollation.getCoercibilityDyadicOperator(NonNullableAccessors.getCollation(argType0), NonNullableAccessors.getCollation(argType1)), () -> "getCoercibilityDyadicOperator is null for " + argType0 + " and " + argType1);
        }
        SqlTypeName typeName = argType0.getSqlTypeName();
        if (SqlTypeUtil.isBoundedVariableWidth(argType1)) {
            typeName = argType1.getSqlTypeName();
        }
        long x = (long)argType0.getPrecision() + (long)argType1.getPrecision();
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataTypeSystem typeSystem = typeFactory.getTypeSystem();
        int typePrecision = argType0.getPrecision() == -1 || argType1.getPrecision() == -1 || x > (long)typeSystem.getMaxPrecision(typeName) ? -1 : (int)x;
        RelDataType ret = typeFactory.createSqlType(typeName, typePrecision);
        if (null != pickedCollation) {
            RelDataType pickedType;
            if (NonNullableAccessors.getCollation(argType0).equals(pickedCollation)) {
                pickedType = argType0;
            } else if (NonNullableAccessors.getCollation(argType1).equals(pickedCollation)) {
                pickedType = argType1;
            } else {
                throw new AssertionError((Object)("should never come here, argType0=" + argType0 + ", argType1=" + argType1));
            }
            ret = typeFactory.createTypeWithCharsetAndCollation(ret, NonNullableAccessors.getCharset(pickedType), NonNullableAccessors.getCollation(pickedType));
        }
        if (ret.getSqlTypeName() == SqlTypeName.NULL) {
            ret = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
        }
        return ret;
    };
    public static final SqlReturnTypeInference MULTIVALENT_STRING_SUM_PRECISION = opBinding -> {
        boolean hasPrecisionNotSpecifiedOperand = false;
        boolean precisionOverflow = false;
        long amount = 0L;
        List<RelDataType> operandTypes = opBinding.collectOperandTypes();
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataTypeSystem typeSystem = typeFactory.getTypeSystem();
        for (RelDataType operandType : operandTypes) {
            int operandPrecision = operandType.getPrecision();
            amount = (long)operandPrecision + amount;
            if (operandPrecision == -1) {
                hasPrecisionNotSpecifiedOperand = true;
                break;
            }
            if (amount <= (long)typeSystem.getMaxPrecision(SqlTypeName.VARCHAR)) continue;
            precisionOverflow = true;
            break;
        }
        int typePrecision = hasPrecisionNotSpecifiedOperand || precisionOverflow ? -1 : (int)amount;
        return opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, typePrecision);
    };
    public static final SqlReturnTypeInference MULTIVALENT_STRING_WITH_SEP_SUM_PRECISION = ReturnTypes::multivalentStringWithSepSumPrecision;
    public static final SqlReturnTypeInference MULTIVALENT_STRING_SUM_PRECISION_NULLABLE = MULTIVALENT_STRING_SUM_PRECISION.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference MULTIVALENT_STRING_SUM_PRECISION_NOT_NULLABLE = MULTIVALENT_STRING_SUM_PRECISION.andThen(SqlTypeTransforms.TO_NOT_NULLABLE);
    public static final SqlReturnTypeInference MULTIVALENT_STRING_WITH_SEP_SUM_PRECISION_NOT_NULLABLE = MULTIVALENT_STRING_WITH_SEP_SUM_PRECISION.andThen(SqlTypeTransforms.TO_NOT_NULLABLE);
    public static final SqlReturnTypeInference MULTIVALENT_STRING_WITH_SEP_SUM_PRECISION_ARG0_NULLABLE = MULTIVALENT_STRING_WITH_SEP_SUM_PRECISION.andThen(SqlTypeTransforms.ARG0_NULLABLE);
    public static final SqlReturnTypeInference MULTIVALENT_STRING_SUM_PRECISION_NULLABLE_ALL = MULTIVALENT_STRING_SUM_PRECISION.andThen(SqlTypeTransforms.TO_NULLABLE_ALL);
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION_NULLABLE_VARYING = DYADIC_STRING_SUM_PRECISION.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING);
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION_NULLABLE = DYADIC_STRING_SUM_PRECISION.andThen(SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference SCOPE = opBinding -> {
        SqlCallBinding callBinding = (SqlCallBinding)opBinding;
        SqlValidatorNamespace ns = SqlNonNullableAccessors.getNamespace(callBinding);
        return ns.getRowType();
    };
    public static final SqlReturnTypeInference MULTISET_PROJECT0 = opBinding -> {
        assert (opBinding.getOperandCount() == 1);
        RelDataType recordMultisetType = opBinding.getOperandType(0);
        RelDataType multisetType = recordMultisetType.getComponentType();
        if (multisetType == null) {
            throw new AssertionError((Object)("expected a multiset type: " + recordMultisetType));
        }
        List<RelDataTypeField> fields = multisetType.getFieldList();
        assert (!fields.isEmpty());
        RelDataType firstColType = fields.get(0).getType();
        return opBinding.getTypeFactory().createMultisetType(firstColType, -1L);
    };
    public static final SqlReturnTypeInference MULTISET_RECORD = opBinding -> {
        assert (opBinding.getOperandCount() == 1);
        RelDataType multisetType = opBinding.getOperandType(0);
        RelDataType componentType = multisetType.getComponentType();
        if (componentType == null) {
            throw new AssertionError((Object)("expected a multiset type: " + multisetType));
        }
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.builder().add(SqlUtil.deriveAliasFromOrdinal(0), componentType).build();
        return typeFactory.createMultisetType(type, -1L);
    };
    public static final SqlReturnTypeInference RECORD_TO_SCALAR = opBinding -> {
        assert (opBinding.getOperandCount() == 1);
        RelDataType recordType = opBinding.getOperandType(0);
        boolean isStruct = recordType.isStruct();
        int fieldCount = recordType.getFieldCount();
        assert (isStruct && fieldCount == 1);
        RelDataTypeField fieldType = recordType.getFieldList().get(0);
        if (fieldType == null) {
            throw new AssertionError((Object)("expected a record type with one field: " + recordType));
        }
        RelDataType firstColType = fieldType.getType();
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return typeFactory.createTypeWithNullability(firstColType, true);
    };
    public static final SqlReturnTypeInference AGG_SUM = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.getTypeSystem().deriveSumType(typeFactory, opBinding.getOperandType(0));
        if (opBinding.hasEmptyGroup() || opBinding.hasFilter()) {
            return typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    };
    public static final SqlReturnTypeInference AGG_SUM_EMPTY_IS_ZERO = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType sumType = typeFactory.getTypeSystem().deriveSumType(typeFactory, opBinding.getOperandType(0));
        return typeFactory.createTypeWithNullability(sumType, false);
    };
    public static final SqlReturnTypeInference FRACTIONAL_RANK = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return typeFactory.getTypeSystem().deriveFractionalRankType(typeFactory);
    };
    public static final SqlReturnTypeInference RANK = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return typeFactory.getTypeSystem().deriveRankType(typeFactory);
    };
    public static final SqlReturnTypeInference AVG_AGG_FUNCTION = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType relDataType = typeFactory.getTypeSystem().deriveAvgAggType(typeFactory, opBinding.getOperandType(0));
        if (opBinding.hasEmptyGroup() || opBinding.hasFilter() || opBinding.getOperator().kind == SqlKind.STDDEV_SAMP) {
            return typeFactory.createTypeWithNullability(relDataType, true);
        }
        return relDataType;
    };
    public static final SqlReturnTypeInference COVAR_REGR_FUNCTION = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType relDataType = typeFactory.getTypeSystem().deriveCovarType(typeFactory, opBinding.getOperandType(0), opBinding.getOperandType(1));
        if (opBinding.hasEmptyGroup() || opBinding.hasFilter()) {
            return typeFactory.createTypeWithNullability(relDataType, true);
        }
        return relDataType;
    };
    public static final SqlReturnTypeInference PERCENTILE_DISC_CONT = SqlOperatorBinding::getCollationType;

    private ReturnTypes() {
    }

    public static SqlReturnTypeInferenceChain chain(SqlReturnTypeInference ... rules) {
        return new SqlReturnTypeInferenceChain(rules);
    }

    public static SqlTypeTransformCascade cascade(SqlReturnTypeInference rule, SqlTypeTransform ... transforms) {
        return new SqlTypeTransformCascade(rule, transforms);
    }

    public static ExplicitReturnTypeInference explicit(RelProtoDataType protoType) {
        return new ExplicitReturnTypeInference(protoType);
    }

    public static ExplicitReturnTypeInference explicit(RelDataType type) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(type));
    }

    public static ExplicitReturnTypeInference explicit(SqlTypeName typeName) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(typeName, false));
    }

    public static ExplicitReturnTypeInference explicit(SqlTypeName typeName, int precision) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(typeName, precision, false));
    }

    public static SqlReturnTypeInference andThen(UnaryOperator<SqlOperatorBinding> bindingTransform, SqlReturnTypeInference typeInference) {
        return opBinding -> typeInference.inferReturnType((SqlOperatorBinding)bindingTransform.apply(opBinding));
    }

    public static SqlOperatorBinding stripOrderBy(SqlOperatorBinding operatorBinding) {
        SqlCallBinding callBinding;
        SqlCall call2;
        SqlCall call3;
        if (operatorBinding instanceof SqlCallBinding && (call3 = ReturnTypes.stripOrderBy(call2 = ReturnTypes.stripSeparator((callBinding = (SqlCallBinding)operatorBinding).getCall()))) != callBinding.getCall()) {
            return new SqlCallBinding(callBinding.getValidator(), callBinding.getScope(), call3);
        }
        return operatorBinding;
    }

    public static SqlCall stripOrderBy(SqlCall call) {
        if (!call.getOperandList().isEmpty() && Util.last(call.getOperandList()) instanceof SqlNodeList) {
            return call.getOperator().createCall(call.getFunctionQuantifier(), call.getParserPosition(), Util.skipLast(call.getOperandList()));
        }
        return call;
    }

    public static SqlCall stripSeparator(SqlCall call) {
        if (!call.getOperandList().isEmpty() && Util.last(call.getOperandList()).getKind() == SqlKind.SEPARATOR) {
            return call.getOperator().createCall(call.getFunctionQuantifier(), call.getParserPosition(), Util.skipLast(call.getOperandList()));
        }
        return call;
    }

    private static @Nullable RelDataType leastRestrictive(SqlOperatorBinding opBinding) {
        return opBinding.getTypeFactory().leastRestrictive(opBinding.collectOperandTypes());
    }

    private static RelDataType multivalentStringWithSepSumPrecision(SqlOperatorBinding opBinding) {
        boolean hasPrecisionNotSpecifiedOperand = false;
        boolean precisionOverflow = false;
        int typePrecision = -1;
        long amount = 0L;
        List<RelDataType> operandTypes = opBinding.collectOperandTypes();
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataTypeSystem typeSystem = typeFactory.getTypeSystem();
        int separatorPrecision = operandTypes.get(0).getPrecision();
        if (separatorPrecision == typePrecision) {
            return typeFactory.createSqlType(SqlTypeName.VARCHAR, typePrecision);
        }
        for (int i = 1; i < operandTypes.size(); ++i) {
            int operandPrecision = operandTypes.get(i).getPrecision();
            amount = (long)operandPrecision + amount;
            if (operandPrecision >= 0 && i < operandTypes.size() - 1) {
                amount += (long)separatorPrecision;
            }
            if (operandPrecision == -1) {
                hasPrecisionNotSpecifiedOperand = true;
                break;
            }
            if (amount <= (long)typeSystem.getMaxPrecision(SqlTypeName.VARCHAR)) continue;
            precisionOverflow = true;
            break;
        }
        if (!hasPrecisionNotSpecifiedOperand && !precisionOverflow) {
            typePrecision = (int)amount;
        }
        return typeFactory.createSqlType(SqlTypeName.VARCHAR, typePrecision);
    }
}

