/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.opensearch._types.analysis.KuromojiTokenizationMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KuromojiAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, KuromojiAnalyzer> {
    @Nonnull
    private final KuromojiTokenizationMode mode;
    @Nullable
    private final String userDictionary;
    public static final JsonpDeserializer<KuromojiAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiAnalyzer::setupKuromojiAnalyzerDeserializer);

    private KuromojiAnalyzer(Builder builder) {
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.userDictionary = builder.userDictionary;
    }

    public static KuromojiAnalyzer of(Function<Builder, ObjectBuilder<KuromojiAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Kuromoji;
    }

    @Nonnull
    public final KuromojiTokenizationMode mode() {
        return this.mode;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji");
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKuromojiAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, KuromojiTokenizationMode._DESERIALIZER, "mode");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + Objects.hashCode(this.userDictionary);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KuromojiAnalyzer other = (KuromojiAnalyzer)o;
        return this.mode.equals(other.mode) && Objects.equals(this.userDictionary, other.userDictionary);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, KuromojiAnalyzer> {
        private KuromojiTokenizationMode mode;
        @Nullable
        private String userDictionary;

        public Builder() {
        }

        private Builder(KuromojiAnalyzer o) {
            this.mode = o.mode;
            this.userDictionary = o.userDictionary;
        }

        private Builder(Builder o) {
            this.mode = o.mode;
            this.userDictionary = o.userDictionary;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder mode(KuromojiTokenizationMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        @Override
        @Nonnull
        public KuromojiAnalyzer build() {
            this._checkSingleUse();
            return new KuromojiAnalyzer(this);
        }
    }
}

