/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthenticateAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;

public class DecryptStructureInput {
    private final String tableName;
    private final Map<String, StructuredDataTerminal> encryptedStructure;
    private final Map<String, AuthenticateAction> authenticateSchema;
    private final ICryptographicMaterialsManager cmm;
    private final Map<String, String> encryptionContext;

    protected DecryptStructureInput(BuilderImpl builder) {
        this.tableName = builder.tableName();
        this.encryptedStructure = builder.encryptedStructure();
        this.authenticateSchema = builder.authenticateSchema();
        this.cmm = builder.cmm();
        this.encryptionContext = builder.encryptionContext();
    }

    public String tableName() {
        return this.tableName;
    }

    public Map<String, StructuredDataTerminal> encryptedStructure() {
        return this.encryptedStructure;
    }

    public Map<String, AuthenticateAction> authenticateSchema() {
        return this.authenticateSchema;
    }

    public ICryptographicMaterialsManager cmm() {
        return this.cmm;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String tableName;
        protected Map<String, StructuredDataTerminal> encryptedStructure;
        protected Map<String, AuthenticateAction> authenticateSchema;
        protected ICryptographicMaterialsManager cmm;
        protected Map<String, String> encryptionContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptStructureInput model) {
            this.tableName = model.tableName();
            this.encryptedStructure = model.encryptedStructure();
            this.authenticateSchema = model.authenticateSchema();
            this.cmm = model.cmm();
            this.encryptionContext = model.encryptionContext();
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public Builder encryptedStructure(Map<String, StructuredDataTerminal> encryptedStructure) {
            this.encryptedStructure = encryptedStructure;
            return this;
        }

        @Override
        public Map<String, StructuredDataTerminal> encryptedStructure() {
            return this.encryptedStructure;
        }

        @Override
        public Builder authenticateSchema(Map<String, AuthenticateAction> authenticateSchema) {
            this.authenticateSchema = authenticateSchema;
            return this;
        }

        @Override
        public Map<String, AuthenticateAction> authenticateSchema() {
            return this.authenticateSchema;
        }

        @Override
        public Builder cmm(ICryptographicMaterialsManager cmm) {
            this.cmm = CryptographicMaterialsManager.wrap((ICryptographicMaterialsManager)cmm);
            return this;
        }

        @Override
        public ICryptographicMaterialsManager cmm() {
            return this.cmm;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public DecryptStructureInput build() {
            if (Objects.isNull(this.tableName())) {
                throw new IllegalArgumentException("Missing value for required field `tableName`");
            }
            if (Objects.isNull(this.encryptedStructure())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedStructure`");
            }
            if (Objects.isNull(this.authenticateSchema())) {
                throw new IllegalArgumentException("Missing value for required field `authenticateSchema`");
            }
            if (Objects.isNull(this.cmm())) {
                throw new IllegalArgumentException("Missing value for required field `cmm`");
            }
            return new DecryptStructureInput(this);
        }
    }

    public static interface Builder {
        public Builder tableName(String var1);

        public String tableName();

        public Builder encryptedStructure(Map<String, StructuredDataTerminal> var1);

        public Map<String, StructuredDataTerminal> encryptedStructure();

        public Builder authenticateSchema(Map<String, AuthenticateAction> var1);

        public Map<String, AuthenticateAction> authenticateSchema();

        public Builder cmm(ICryptographicMaterialsManager var1);

        public ICryptographicMaterialsManager cmm();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public DecryptStructureInput build();
    }
}

