/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance;

import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceException;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.Map;
import java.util.Optional;

public interface ObjectProvenance
extends Provenance,
Iterable<Pair<String, Provenance>> {
    public static final String CLASS_NAME = "class-name";
    public static final ProvenanceUtil.HashType DEFAULT_HASH_TYPE = ProvenanceUtil.HashType.SHA256;

    public String getClassName();

    default public String generateString(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        for (Pair p : this) {
            sb.append((String)p.getA());
            sb.append('=');
            sb.append(((Provenance)p.getB()).toString());
            sb.append(',');
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        return sb.toString();
    }

    public static <T extends Provenance> T checkAndExtractProvenance(Map<String, Provenance> map, String key, Class<T> type, String provClassName) throws ProvenanceException {
        Optional<T> prov = ObjectProvenance.maybeExtractProvenance(map, key, type, provClassName);
        if (prov.isPresent()) {
            return (T)((Provenance)prov.get());
        }
        throw new ProvenanceException("Failed to find " + key + " when constructing " + provClassName);
    }

    public static <T extends Provenance> Optional<T> maybeExtractProvenance(Map<String, Provenance> map, String key, Class<T> type, String provClassName) throws ProvenanceException {
        Provenance tmp = map.remove(key);
        if (tmp != null) {
            if (type.isInstance(tmp)) {
                return Optional.of(tmp);
            }
            throw new ProvenanceException("Failed to cast " + key + " when constructing " + provClassName + ", found " + tmp);
        }
        return Optional.empty();
    }
}

