/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue;
import software.amazon.awssdk.services.ec2.model.DnsSupportValue;
import software.amazon.awssdk.services.ec2.model.SecurityGroupReferencingSupportValue;
import software.amazon.awssdk.services.ec2.model.TransitGatewayCidrBlockStringListCopier;
import software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTransitGatewayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModifyTransitGatewayOptions> {
    private static final SdkField<List<String>> ADD_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddTransitGatewayCidrBlocks").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::addTransitGatewayCidrBlocks)).setter(ModifyTransitGatewayOptions.setter(Builder::addTransitGatewayCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTransitGatewayCidrBlocks").unmarshallLocationName("AddTransitGatewayCidrBlocks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveTransitGatewayCidrBlocks").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::removeTransitGatewayCidrBlocks)).setter(ModifyTransitGatewayOptions.setter(Builder::removeTransitGatewayCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTransitGatewayCidrBlocks").unmarshallLocationName("RemoveTransitGatewayCidrBlocks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnEcmpSupport").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::vpnEcmpSupportAsString)).setter(ModifyTransitGatewayOptions.setter(Builder::vpnEcmpSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport").unmarshallLocationName("VpnEcmpSupport").build()}).build();
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsSupport").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::dnsSupportAsString)).setter(ModifyTransitGatewayOptions.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").unmarshallLocationName("DnsSupport").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_REFERENCING_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupReferencingSupport").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::securityGroupReferencingSupportAsString)).setter(ModifyTransitGatewayOptions.setter(Builder::securityGroupReferencingSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupReferencingSupport").unmarshallLocationName("SecurityGroupReferencingSupport").build()}).build();
    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoAcceptSharedAttachments").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::autoAcceptSharedAttachmentsAsString)).setter(ModifyTransitGatewayOptions.setter(Builder::autoAcceptSharedAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments").unmarshallLocationName("AutoAcceptSharedAttachments").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRouteTableAssociation").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::defaultRouteTableAssociationAsString)).setter(ModifyTransitGatewayOptions.setter(Builder::defaultRouteTableAssociation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation").unmarshallLocationName("DefaultRouteTableAssociation").build()}).build();
    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationDefaultRouteTableId").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::associationDefaultRouteTableId)).setter(ModifyTransitGatewayOptions.setter(Builder::associationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId").unmarshallLocationName("AssociationDefaultRouteTableId").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRouteTablePropagation").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::defaultRouteTablePropagationAsString)).setter(ModifyTransitGatewayOptions.setter(Builder::defaultRouteTablePropagation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation").unmarshallLocationName("DefaultRouteTablePropagation").build()}).build();
    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropagationDefaultRouteTableId").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::propagationDefaultRouteTableId)).setter(ModifyTransitGatewayOptions.setter(Builder::propagationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId").unmarshallLocationName("PropagationDefaultRouteTableId").build()}).build();
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AmazonSideAsn").getter(ModifyTransitGatewayOptions.getter(ModifyTransitGatewayOptions::amazonSideAsn)).setter(ModifyTransitGatewayOptions.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").unmarshallLocationName("AmazonSideAsn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, REMOVE_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD, SECURITY_GROUP_REFERENCING_SUPPORT_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD, ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD, PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, AMAZON_SIDE_ASN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyTransitGatewayOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> addTransitGatewayCidrBlocks;
    private final List<String> removeTransitGatewayCidrBlocks;
    private final String vpnEcmpSupport;
    private final String dnsSupport;
    private final String securityGroupReferencingSupport;
    private final String autoAcceptSharedAttachments;
    private final String defaultRouteTableAssociation;
    private final String associationDefaultRouteTableId;
    private final String defaultRouteTablePropagation;
    private final String propagationDefaultRouteTableId;
    private final Long amazonSideAsn;

    private ModifyTransitGatewayOptions(BuilderImpl builder) {
        this.addTransitGatewayCidrBlocks = builder.addTransitGatewayCidrBlocks;
        this.removeTransitGatewayCidrBlocks = builder.removeTransitGatewayCidrBlocks;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
        this.securityGroupReferencingSupport = builder.securityGroupReferencingSupport;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.amazonSideAsn = builder.amazonSideAsn;
    }

    public final boolean hasAddTransitGatewayCidrBlocks() {
        return this.addTransitGatewayCidrBlocks != null && !(this.addTransitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> addTransitGatewayCidrBlocks() {
        return this.addTransitGatewayCidrBlocks;
    }

    public final boolean hasRemoveTransitGatewayCidrBlocks() {
        return this.removeTransitGatewayCidrBlocks != null && !(this.removeTransitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> removeTransitGatewayCidrBlocks() {
        return this.removeTransitGatewayCidrBlocks;
    }

    public final VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(this.vpnEcmpSupport);
    }

    public final String vpnEcmpSupportAsString() {
        return this.vpnEcmpSupport;
    }

    public final DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(this.dnsSupport);
    }

    public final String dnsSupportAsString() {
        return this.dnsSupport;
    }

    public final SecurityGroupReferencingSupportValue securityGroupReferencingSupport() {
        return SecurityGroupReferencingSupportValue.fromValue(this.securityGroupReferencingSupport);
    }

    public final String securityGroupReferencingSupportAsString() {
        return this.securityGroupReferencingSupport;
    }

    public final AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(this.autoAcceptSharedAttachments);
    }

    public final String autoAcceptSharedAttachmentsAsString() {
        return this.autoAcceptSharedAttachments;
    }

    public final DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(this.defaultRouteTableAssociation);
    }

    public final String defaultRouteTableAssociationAsString() {
        return this.defaultRouteTableAssociation;
    }

    public final String associationDefaultRouteTableId() {
        return this.associationDefaultRouteTableId;
    }

    public final DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(this.defaultRouteTablePropagation);
    }

    public final String defaultRouteTablePropagationAsString() {
        return this.defaultRouteTablePropagation;
    }

    public final String propagationDefaultRouteTableId() {
        return this.propagationDefaultRouteTableId;
    }

    public final Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddTransitGatewayCidrBlocks() ? this.addTransitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveTransitGatewayCidrBlocks() ? this.removeTransitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupReferencingSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayOptions)) {
            return false;
        }
        ModifyTransitGatewayOptions other = (ModifyTransitGatewayOptions)obj;
        return this.hasAddTransitGatewayCidrBlocks() == other.hasAddTransitGatewayCidrBlocks() && Objects.equals(this.addTransitGatewayCidrBlocks(), other.addTransitGatewayCidrBlocks()) && this.hasRemoveTransitGatewayCidrBlocks() == other.hasRemoveTransitGatewayCidrBlocks() && Objects.equals(this.removeTransitGatewayCidrBlocks(), other.removeTransitGatewayCidrBlocks()) && Objects.equals(this.vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString()) && Objects.equals(this.dnsSupportAsString(), other.dnsSupportAsString()) && Objects.equals(this.securityGroupReferencingSupportAsString(), other.securityGroupReferencingSupportAsString()) && Objects.equals(this.autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString()) && Objects.equals(this.defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString()) && Objects.equals(this.associationDefaultRouteTableId(), other.associationDefaultRouteTableId()) && Objects.equals(this.defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString()) && Objects.equals(this.propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyTransitGatewayOptions").add("AddTransitGatewayCidrBlocks", this.hasAddTransitGatewayCidrBlocks() ? this.addTransitGatewayCidrBlocks() : null).add("RemoveTransitGatewayCidrBlocks", this.hasRemoveTransitGatewayCidrBlocks() ? this.removeTransitGatewayCidrBlocks() : null).add("VpnEcmpSupport", (Object)this.vpnEcmpSupportAsString()).add("DnsSupport", (Object)this.dnsSupportAsString()).add("SecurityGroupReferencingSupport", (Object)this.securityGroupReferencingSupportAsString()).add("AutoAcceptSharedAttachments", (Object)this.autoAcceptSharedAttachmentsAsString()).add("DefaultRouteTableAssociation", (Object)this.defaultRouteTableAssociationAsString()).add("AssociationDefaultRouteTableId", (Object)this.associationDefaultRouteTableId()).add("DefaultRouteTablePropagation", (Object)this.defaultRouteTablePropagationAsString()).add("PropagationDefaultRouteTableId", (Object)this.propagationDefaultRouteTableId()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddTransitGatewayCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.addTransitGatewayCidrBlocks()));
            }
            case "RemoveTransitGatewayCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.removeTransitGatewayCidrBlocks()));
            }
            case "VpnEcmpSupport": {
                return Optional.ofNullable(clazz.cast(this.vpnEcmpSupportAsString()));
            }
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupportAsString()));
            }
            case "SecurityGroupReferencingSupport": {
                return Optional.ofNullable(clazz.cast(this.securityGroupReferencingSupportAsString()));
            }
            case "AutoAcceptSharedAttachments": {
                return Optional.ofNullable(clazz.cast(this.autoAcceptSharedAttachmentsAsString()));
            }
            case "DefaultRouteTableAssociation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTableAssociationAsString()));
            }
            case "AssociationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.associationDefaultRouteTableId()));
            }
            case "DefaultRouteTablePropagation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTablePropagationAsString()));
            }
            case "PropagationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.propagationDefaultRouteTableId()));
            }
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddTransitGatewayCidrBlocks", ADD_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD);
        map.put("RemoveTransitGatewayCidrBlocks", REMOVE_TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD);
        map.put("VpnEcmpSupport", VPN_ECMP_SUPPORT_FIELD);
        map.put("DnsSupport", DNS_SUPPORT_FIELD);
        map.put("SecurityGroupReferencingSupport", SECURITY_GROUP_REFERENCING_SUPPORT_FIELD);
        map.put("AutoAcceptSharedAttachments", AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD);
        map.put("DefaultRouteTableAssociation", DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD);
        map.put("AssociationDefaultRouteTableId", ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD);
        map.put("DefaultRouteTablePropagation", DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD);
        map.put("PropagationDefaultRouteTableId", PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD);
        map.put("AmazonSideAsn", AMAZON_SIDE_ASN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayOptions, T> g) {
        return obj -> g.apply((ModifyTransitGatewayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> addTransitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeTransitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private String vpnEcmpSupport;
        private String dnsSupport;
        private String securityGroupReferencingSupport;
        private String autoAcceptSharedAttachments;
        private String defaultRouteTableAssociation;
        private String associationDefaultRouteTableId;
        private String defaultRouteTablePropagation;
        private String propagationDefaultRouteTableId;
        private Long amazonSideAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayOptions model) {
            this.addTransitGatewayCidrBlocks(model.addTransitGatewayCidrBlocks);
            this.removeTransitGatewayCidrBlocks(model.removeTransitGatewayCidrBlocks);
            this.vpnEcmpSupport(model.vpnEcmpSupport);
            this.dnsSupport(model.dnsSupport);
            this.securityGroupReferencingSupport(model.securityGroupReferencingSupport);
            this.autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            this.defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            this.associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            this.defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            this.propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            this.amazonSideAsn(model.amazonSideAsn);
        }

        public final Collection<String> getAddTransitGatewayCidrBlocks() {
            if (this.addTransitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addTransitGatewayCidrBlocks;
        }

        public final void setAddTransitGatewayCidrBlocks(Collection<String> addTransitGatewayCidrBlocks) {
            this.addTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(addTransitGatewayCidrBlocks);
        }

        @Override
        public final Builder addTransitGatewayCidrBlocks(Collection<String> addTransitGatewayCidrBlocks) {
            this.addTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(addTransitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTransitGatewayCidrBlocks(String ... addTransitGatewayCidrBlocks) {
            this.addTransitGatewayCidrBlocks(Arrays.asList(addTransitGatewayCidrBlocks));
            return this;
        }

        public final Collection<String> getRemoveTransitGatewayCidrBlocks() {
            if (this.removeTransitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeTransitGatewayCidrBlocks;
        }

        public final void setRemoveTransitGatewayCidrBlocks(Collection<String> removeTransitGatewayCidrBlocks) {
            this.removeTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(removeTransitGatewayCidrBlocks);
        }

        @Override
        public final Builder removeTransitGatewayCidrBlocks(Collection<String> removeTransitGatewayCidrBlocks) {
            this.removeTransitGatewayCidrBlocks = TransitGatewayCidrBlockStringListCopier.copy(removeTransitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTransitGatewayCidrBlocks(String ... removeTransitGatewayCidrBlocks) {
            this.removeTransitGatewayCidrBlocks(Arrays.asList(removeTransitGatewayCidrBlocks));
            return this;
        }

        public final String getVpnEcmpSupport() {
            return this.vpnEcmpSupport;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport == null ? null : vpnEcmpSupport.toString());
            return this;
        }

        public final String getDnsSupport() {
            return this.dnsSupport;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport == null ? null : dnsSupport.toString());
            return this;
        }

        public final String getSecurityGroupReferencingSupport() {
            return this.securityGroupReferencingSupport;
        }

        public final void setSecurityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
        }

        @Override
        public final Builder securityGroupReferencingSupport(String securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
            return this;
        }

        @Override
        public final Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport(securityGroupReferencingSupport == null ? null : securityGroupReferencingSupport.toString());
            return this;
        }

        public final String getAutoAcceptSharedAttachments() {
            return this.autoAcceptSharedAttachments;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments == null ? null : autoAcceptSharedAttachments.toString());
            return this;
        }

        public final String getDefaultRouteTableAssociation() {
            return this.defaultRouteTableAssociation;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation == null ? null : defaultRouteTableAssociation.toString());
            return this;
        }

        public final String getAssociationDefaultRouteTableId() {
            return this.associationDefaultRouteTableId;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final String getDefaultRouteTablePropagation() {
            return this.defaultRouteTablePropagation;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation == null ? null : defaultRouteTablePropagation.toString());
            return this;
        }

        public final String getPropagationDefaultRouteTableId() {
            return this.propagationDefaultRouteTableId;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public ModifyTransitGatewayOptions build() {
            return new ModifyTransitGatewayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModifyTransitGatewayOptions> {
        public Builder addTransitGatewayCidrBlocks(Collection<String> var1);

        public Builder addTransitGatewayCidrBlocks(String ... var1);

        public Builder removeTransitGatewayCidrBlocks(Collection<String> var1);

        public Builder removeTransitGatewayCidrBlocks(String ... var1);

        public Builder vpnEcmpSupport(String var1);

        public Builder vpnEcmpSupport(VpnEcmpSupportValue var1);

        public Builder dnsSupport(String var1);

        public Builder dnsSupport(DnsSupportValue var1);

        public Builder securityGroupReferencingSupport(String var1);

        public Builder securityGroupReferencingSupport(SecurityGroupReferencingSupportValue var1);

        public Builder autoAcceptSharedAttachments(String var1);

        public Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue var1);

        public Builder defaultRouteTableAssociation(String var1);

        public Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue var1);

        public Builder associationDefaultRouteTableId(String var1);

        public Builder defaultRouteTablePropagation(String var1);

        public Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue var1);

        public Builder propagationDefaultRouteTableId(String var1);

        public Builder amazonSideAsn(Long var1);
    }
}

