/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public record IngestionStateShardFailure(String index, int shard, String errorMessage) implements Writeable,
ToXContentFragment
{
    private static final String SHARD = "shard";
    private static final String ERROR = "error";

    public IngestionStateShardFailure(StreamInput in) throws IOException {
        this(in.readString(), in.readVInt(), in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shard);
        out.writeString(this.errorMessage);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SHARD, this.shard);
        builder.field(ERROR, this.errorMessage);
        return builder.endObject();
    }

    public static Map<String, List<IngestionStateShardFailure>> groupShardFailuresByIndex(IngestionStateShardFailure[] shardFailures) {
        HashMap<String, List<IngestionStateShardFailure>> shardFailuresByIndex = new HashMap<String, List<IngestionStateShardFailure>>();
        for (IngestionStateShardFailure shardFailure : shardFailures) {
            shardFailuresByIndex.computeIfAbsent(shardFailure.index(), index -> new ArrayList());
            ((List)shardFailuresByIndex.get(shardFailure.index())).add(shardFailure);
        }
        return shardFailuresByIndex;
    }
}

