/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.StorageProviderRealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.storage.StoreSyncEvent;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderClusterEvent;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageSyncTask;
import org.keycloak.storage.user.ImportSynchronization;

public final class UserStorageEventListener
implements ClusterListener,
ProviderEventListener {
    private static final Logger logger = Logger.getLogger(UserStorageEventListener.class);
    private static final String USER_STORAGE_TASK_KEY = "user-storage";
    private final KeycloakSessionFactory sessionFactory;

    public UserStorageEventListener(KeycloakSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void eventReceived(ClusterEvent event) {
        UserStorageProviderClusterEvent fedEvent = (UserStorageProviderClusterEvent)event;
        String realmId = fedEvent.getRealmId();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
            RealmModel realm = session.realms().getRealm(realmId);
            if (realm == null) {
                throw new RuntimeException("Failed to execute session task. Realm with id " + realmId + " not found.");
            }
            session.getContext().setRealm(realm);
            this.refreshScheduledTasks(session, fedEvent.getStorageProvider(), fedEvent.isRemoved());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ProviderEvent event) {
        if (event instanceof PostMigrationEvent) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
                session.realms().getRealmsWithProviderTypeStream(UserStorageProvider.class).forEach(realm -> {
                    try {
                        session.getContext().setRealm(realm);
                        this.getUserStorageProvidersStream((RealmModel)realm).forEachOrdered(provider -> this.reScheduleTasks(session, (UserStorageProviderModel)provider));
                    }
                    finally {
                        session.getContext().setRealm(null);
                    }
                });
                ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
                if (clusterProvider != null) {
                    clusterProvider.registerListener(USER_STORAGE_TASK_KEY, (ClusterListener)this);
                }
            });
        } else if (event instanceof StoreSyncEvent) {
            StoreSyncEvent ev = (StoreSyncEvent)event;
            UserStorageProviderModel model = ev.getModel() == null ? null : new UserStorageProviderModel(ev.getModel());
            KeycloakSession session2 = ev.getSession();
            boolean removed = ev.getRemoved();
            RealmModel contextRealm = session2.getContext().getRealm();
            RealmModel realm = ev.getRealm();
            try {
                session2.getContext().setRealm(realm);
                if (model != null) {
                    this.refreshScheduledTasks(session2, model, removed);
                    this.notifyStoreSyncClusterUpdate(session2, realm, model, removed);
                } else {
                    this.getUserStorageProvidersStream(realm).forEachOrdered(fedProvider -> {
                        this.refreshScheduledTasks(session2, (UserStorageProviderModel)fedProvider, removed);
                        this.notifyStoreSyncClusterUpdate(session2, realm, (UserStorageProviderModel)fedProvider, removed);
                    });
                }
            }
            finally {
                session2.getContext().setRealm(contextRealm);
            }
        }
    }

    private void reScheduleTasks(KeycloakSession session, UserStorageProviderModel provider) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        UserStorageProviderFactory factory = (UserStorageProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, provider.getProviderId());
        RealmModel realm = session.getContext().getRealm();
        if (!(factory instanceof ImportSynchronization)) {
            logger.debugf("Not refreshing periodic sync settings for provider '%s' in realm '%s'", (Object)provider.getName(), (Object)realm.getName());
            return;
        }
        logger.debugf("Going to refresh periodic sync settings for provider '%s' in realm '%s' with realmId '%s'. Full sync period: %d , changed users sync period: %d", new Object[]{provider.getName(), realm.getName(), realm.getId(), provider.getFullSyncPeriod(), provider.getChangedSyncPeriod()});
        this.scheduleTask(session, provider, UserStorageProviderModel.SyncMode.FULL);
        this.scheduleTask(session, provider, UserStorageProviderModel.SyncMode.CHANGED);
    }

    private void scheduleTask(KeycloakSession session, UserStorageProviderModel provider, UserStorageProviderModel.SyncMode mode) {
        UserStorageSyncTask task = new UserStorageSyncTask(provider, mode);
        if (!task.schedule(session)) {
            task.cancel(session);
        }
    }

    private void notifyStoreSyncClusterUpdate(KeycloakSession session, RealmModel realm, UserStorageProviderModel provider, boolean removed) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        UserStorageProviderFactory factory = (UserStorageProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, provider.getProviderId());
        if (!(factory instanceof ImportSynchronization)) {
            return;
        }
        ClusterProvider cp = (ClusterProvider)session.getProvider(ClusterProvider.class);
        if (cp != null) {
            UserStorageProviderClusterEvent event = UserStorageProviderClusterEvent.createEvent(removed, realm.getId(), provider);
            cp.notify(USER_STORAGE_TASK_KEY, (ClusterEvent)event, true);
        }
    }

    private void refreshScheduledTasks(KeycloakSession session, UserStorageProviderModel model, boolean removed) {
        if (removed) {
            new UserStorageSyncTask(model, UserStorageProviderModel.SyncMode.FULL).cancel(session);
            new UserStorageSyncTask(model, UserStorageProviderModel.SyncMode.CHANGED).cancel(session);
        } else {
            this.reScheduleTasks(session, model);
        }
    }

    private Stream<UserStorageProviderModel> getUserStorageProvidersStream(RealmModel realm) {
        if (realm instanceof StorageProviderRealmModel) {
            StorageProviderRealmModel s = (StorageProviderRealmModel)realm;
            return s.getUserStorageProvidersStream();
        }
        return Stream.empty();
    }
}

