/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieSameSiteMode;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.SameSiteNoneIncompatibleClientChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SameSiteCookieHandler
implements HttpHandler {
    private final HttpHandler next;
    private final String mode;
    private final Pattern cookiePattern;
    private final boolean enableClientChecker;
    private final boolean addSecureForNone;

    public SameSiteCookieHandler(HttpHandler next, String mode) {
        this(next, mode, null, true, true, true);
    }

    public SameSiteCookieHandler(HttpHandler next, String mode, String cookiePattern) {
        this(next, mode, cookiePattern, true, true, true);
    }

    public SameSiteCookieHandler(HttpHandler next, String mode, String cookiePattern, boolean caseSensitive) {
        this(next, mode, cookiePattern, caseSensitive, true, true);
    }

    public SameSiteCookieHandler(HttpHandler next, String mode, String cookiePattern, boolean caseSensitive, boolean enableClientChecker, boolean addSecureForNone) {
        this.next = next;
        this.mode = mode;
        this.cookiePattern = cookiePattern != null && !cookiePattern.isEmpty() ? Pattern.compile(cookiePattern, caseSensitive ? 0 : 2) : null;
        boolean modeIsNone = CookieSameSiteMode.NONE.toString().equalsIgnoreCase(mode);
        this.enableClientChecker = enableClientChecker && modeIsNone;
        this.addSecureForNone = addSecureForNone && modeIsNone;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.mode != null) {
            exchange.addResponseCommitListener(new ResponseCommitListener(){

                @Override
                public void beforeCommit(HttpServerExchange exchange) {
                    String userAgent = exchange.getRequestHeader("User-Agent");
                    if (SameSiteCookieHandler.this.enableClientChecker && userAgent != null && !SameSiteNoneIncompatibleClientChecker.shouldSendSameSiteNone(userAgent)) {
                        return;
                    }
                    for (Map.Entry<String, Cookie> cookie : exchange.getResponseCookies().entrySet()) {
                        if (SameSiteCookieHandler.this.cookiePattern != null && !SameSiteCookieHandler.this.cookiePattern.matcher(cookie.getValue().getName()).matches()) continue;
                        cookie.getValue().setSameSiteMode(SameSiteCookieHandler.this.mode);
                        if (!SameSiteCookieHandler.this.addSecureForNone) continue;
                        cookie.getValue().setSecure(true);
                    }
                }
            });
        }
        this.next.handleRequest(exchange);
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "samesite-cookie";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap parameters = new HashMap();
            parameters.put("mode", String.class);
            parameters.put("cookie-pattern", String.class);
            parameters.put("case-sensitive", Boolean.class);
            parameters.put("enable-client-checker", Boolean.class);
            parameters.put("add-secure-for-none", Boolean.class);
            return parameters;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("mode");
        }

        @Override
        public String defaultParameter() {
            return "mode";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            final String mode = (String)config.get("mode");
            final String pattern = (String)config.get("cookie-pattern");
            final Boolean caseSensitive = (Boolean)config.get("case-sensitive");
            final Boolean enableClientChecker = (Boolean)config.get("enable-client-checker");
            final Boolean addSecureForNone = (Boolean)config.get("add-secure-for-none");
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new SameSiteCookieHandler(handler, mode, pattern, caseSensitive == null ? true : caseSensitive, enableClientChecker == null ? true : enableClientChecker, addSecureForNone == null ? true : addSecureForNone);
                }
            };
        }
    }
}

