/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;

public record DelegationTokenData(TokenInformation tokenInformation) {
    public static DelegationTokenData fromRecord(DelegationTokenRecord record) {
        ArrayList<KafkaPrincipal> renewers = new ArrayList<KafkaPrincipal>();
        for (String renewerString : record.renewers()) {
            renewers.add(SecurityUtils.parseKafkaPrincipal((String)renewerString));
        }
        return new DelegationTokenData(TokenInformation.fromRecord((String)record.tokenId(), (KafkaPrincipal)SecurityUtils.parseKafkaPrincipal((String)record.owner()), (KafkaPrincipal)SecurityUtils.parseKafkaPrincipal((String)record.requester()), renewers, (long)record.issueTimestamp(), (long)record.maxTimestamp(), (long)record.expirationTimestamp()));
    }

    public DelegationTokenRecord toRecord() {
        return new DelegationTokenRecord().setOwner(this.tokenInformation.ownerAsString()).setRequester(this.tokenInformation.tokenRequesterAsString()).setRenewers(new ArrayList<String>(this.tokenInformation.renewersAsString())).setIssueTimestamp(this.tokenInformation.issueTimestamp()).setMaxTimestamp(this.tokenInformation.maxTimestamp()).setExpirationTimestamp(this.tokenInformation.expiryTimestamp()).setTokenId(this.tokenInformation.tokenId());
    }

    @Override
    public String toString() {
        return "DelegationTokenData(tokenInformation=[hidden])";
    }
}

