/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;

public class NIOUtils {
    NIOUtils() {
    }

    public static void closeKeyAndChannelSilently(SelectionKey selectionKey, Channel channel) {
        NIOUtils.closeChannelSilently(channel);
        NIOUtils.cancelKeySilently(selectionKey);
    }

    public static void setPacketSizeInByteBuffer(ByteBuffer byteBuffer, int n, int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Payload size is less than 0.");
        }
        if (n != 4 && n2 >> n * 8 > 0) {
            throw new IllegalArgumentException("Payload size cannot be encoded into " + n + " byte(s).");
        }
        for (int i = 0; i < n; ++i) {
            int n3 = bl ? n - 1 - i : i;
            byteBuffer.put((byte)(n2 >> 8 * n3 & 0xFF));
        }
    }

    public static void setHeaderForPacketSize(byte[] byArray, int n, int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Payload size is less than 0.");
        }
        if (n != 4 && n2 >> n * 8 > 0) {
            throw new IllegalArgumentException("Payload size cannot be encoded into " + n + " byte(s).");
        }
        for (int i = 0; i < n; ++i) {
            int n3 = bl ? n - 1 - i : i;
            byArray[i] = (byte)(n2 >> 8 * n3 & 0xFF);
        }
    }

    public static int getPacketSizeFromByteBuffer(ByteBuffer byteBuffer, int n, boolean bl) {
        long l = 0L;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                l <<= 8;
                l += (long)(byteBuffer.get() & 0xFF);
            }
        } else {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                l += (long)((byteBuffer.get() & 0xFF) << n2);
                n2 += 8;
            }
        }
        return (int)l;
    }

    public static int getPacketSizeFromByteArray(byte[] byArray, int n, boolean bl) {
        long l = 0L;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                l <<= 8;
                l += (long)(byArray[i] & 0xFF);
            }
        } else {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                l += (long)((byArray[i] & 0xFF) << n2);
                n2 += 8;
            }
        }
        return (int)l;
    }

    public static void closeChannelSilently(Channel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void cancelKeySilently(SelectionKey selectionKey) {
        try {
            if (selectionKey != null) {
                selectionKey.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ByteBuffer[] compact(ByteBuffer[] byteBufferArray) {
        for (int i = 0; i < byteBufferArray.length; ++i) {
            if (byteBufferArray[i].remaining() <= 0) continue;
            if (i == 0) {
                return byteBufferArray;
            }
            ByteBuffer[] byteBufferArray2 = new ByteBuffer[byteBufferArray.length - i];
            System.arraycopy(byteBufferArray, i, byteBufferArray2, 0, byteBufferArray.length - i);
            return byteBufferArray2;
        }
        return null;
    }

    public static ByteBuffer[] concat(ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) {
        return NIOUtils.concat(byteBufferArray, new ByteBuffer[]{byteBuffer});
    }

    public static ByteBuffer[] concat(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) {
        return NIOUtils.concat(new ByteBuffer[]{byteBuffer}, byteBufferArray);
    }

    public static ByteBuffer[] concat(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        if (byteBufferArray == null || byteBufferArray.length == 0) {
            return byteBufferArray2;
        }
        if (byteBufferArray2 == null || byteBufferArray2.length == 0) {
            return byteBufferArray;
        }
        ByteBuffer[] byteBufferArray3 = new ByteBuffer[byteBufferArray.length + byteBufferArray2.length];
        System.arraycopy(byteBufferArray, 0, byteBufferArray3, 0, byteBufferArray.length);
        System.arraycopy(byteBufferArray2, 0, byteBufferArray3, byteBufferArray.length, byteBufferArray2.length);
        return byteBufferArray3;
    }

    public static ByteBuffer copy(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        return byteBuffer2;
    }

    public static long remaining(ByteBuffer[] byteBufferArray) {
        long l = 0L;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            l += (long)byteBuffer.remaining();
        }
        return l;
    }

    public static boolean isEmpty(ByteBuffer[] byteBufferArray) {
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (byteBuffer.remaining() <= 0) continue;
            return false;
        }
        return true;
    }

    public static ByteBuffer join(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer2 == null || byteBuffer2.remaining() == 0) {
            return NIOUtils.copy(byteBuffer);
        }
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return NIOUtils.copy(byteBuffer2);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(byteBuffer.remaining() + byteBuffer2.remaining());
        byteBuffer3.put(byteBuffer);
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.flip();
        return byteBuffer3;
    }
}

