import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { Draggable } from '@hello-pangea/dnd';
import '@grafana/data';
import { useTheme2, InlineField } from '@grafana/ui';
import 'react';
import { OperationEditorBody } from './OperationEditorBody.js';

function OperationEditor({
  operation,
  index,
  onRemove,
  onToggle,
  onChange,
  onRunQuery,
  queryModeller,
  query,
  datasource,
  flash,
  highlight,
  timeRange,
  isConflictingOperation
}) {
  const def = queryModeller.getOperationDefinition(operation.id);
  const theme = useTheme2();
  const isConflicting = isConflictingOperation ? isConflictingOperation(operation, query.operations) : false;
  const styles = getStyles(theme);
  if (!def) {
    return /* @__PURE__ */ jsxs("span", { children: [
      "Operation ",
      operation.id,
      " not found"
    ] });
  }
  const isInvalid = (isDragging) => {
    if (isDragging) {
      return undefined;
    }
    return isConflicting ? true : undefined;
  };
  return /* @__PURE__ */ jsx(Draggable, { draggableId: `operation-${index}`, index, children: (provided, snapshot) => /* @__PURE__ */ jsx(
    InlineField,
    {
      error: "You have conflicting label filters",
      invalid: isInvalid(snapshot.isDragging),
      className: cx(styles.error, styles.cardWrapper),
      children: /* @__PURE__ */ jsx(
        OperationEditorBody,
        {
          provided,
          flash,
          highlight,
          isConflicting,
          index,
          operation,
          definition: def,
          onChange,
          onRemove,
          onToggle,
          queryModeller,
          query,
          timeRange,
          onRunQuery,
          datasource
        }
      )
    }
  ) });
}
const getStyles = (theme, isConflicting) => {
  return {
    cardWrapper: css({
      alignItems: "stretch"
    }),
    error: css({
      marginBottom: theme.spacing(1)
    })
  };
};

export { OperationEditor };
//# sourceMappingURL=OperationEditor.js.map
