/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gradle.testkit.runner.InvalidPluginMetadataException;
import org.gradle.util.internal.GUtil;

public abstract class PluginUnderTestMetadataReading {
    public static final String IMPLEMENTATION_CLASSPATH_PROP_KEY = "implementation-classpath";
    public static final String PLUGIN_METADATA_FILE_NAME = "plugin-under-test-metadata.properties";

    private PluginUnderTestMetadataReading() {
    }

    public static List<File> readImplementationClasspath() {
        return PluginUnderTestMetadataReading.readImplementationClasspath(Thread.currentThread().getContextClassLoader());
    }

    public static List<File> readImplementationClasspath(ClassLoader classLoader) {
        URL pluginClasspathUrl = classLoader.getResource(PLUGIN_METADATA_FILE_NAME);
        if (pluginClasspathUrl == null) {
            throw new InvalidPluginMetadataException(String.format("Test runtime classpath does not contain plugin metadata file '%s'", PLUGIN_METADATA_FILE_NAME));
        }
        return PluginUnderTestMetadataReading.readImplementationClasspath(pluginClasspathUrl);
    }

    public static List<File> readImplementationClasspath(URL pluginClasspathUrl) {
        return PluginUnderTestMetadataReading.readImplementationClasspath(pluginClasspathUrl.toString(), GUtil.loadProperties((URL)pluginClasspathUrl));
    }

    public static List<File> readImplementationClasspath(String description, Properties properties) {
        if (!properties.containsKey(IMPLEMENTATION_CLASSPATH_PROP_KEY)) {
            throw new InvalidPluginMetadataException(String.format("Plugin metadata file '%s' does not contain expected property named '%s'", description, IMPLEMENTATION_CLASSPATH_PROP_KEY));
        }
        String value = properties.getProperty(IMPLEMENTATION_CLASSPATH_PROP_KEY);
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.isEmpty()) {
            throw new InvalidPluginMetadataException(String.format("Plugin metadata file '%s' has empty value for property named '%s'", description, IMPLEMENTATION_CLASSPATH_PROP_KEY));
        }
        String[] parsedImplementationClasspath = value.trim().split(File.pathSeparator);
        ArrayList<File> files = new ArrayList<File>(parsedImplementationClasspath.length);
        for (String path : parsedImplementationClasspath) {
            files.add(new File(path));
        }
        return files;
    }
}

