/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.SPARC_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class SPARC_ElfRelocationHandler
extends AbstractElfRelocationHandler<SPARC_ElfRelocationType, ElfRelocationContext<?>> {
    public SPARC_ElfRelocationHandler() {
        super(SPARC_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        boolean handleMachine = elf.e_machine() == 2 || elf.e_machine() == 18 || elf.e_machine() == 43;
        return handleMachine && elf.is32Bit();
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, SPARC_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        long addend = relocation.getAddend();
        long pc = relocationAddress.getOffset();
        int symbolIndex = relocation.getSymbolIndex();
        int oldValue = memory.getInt(relocationAddress);
        long newValue = 0L;
        int mask = 0;
        int byteLength = 4;
        switch (type) {
            case R_SPARC_RELATIVE: {
                newValue = elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setInt(relocationAddress, (int)newValue);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_SPARC_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_SPARC_8: {
                newValue = symbolValue + addend;
                mask = 255;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_16: {
                newValue = symbolValue + addend;
                mask = 65535;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_32: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, (int)newValue);
                break;
            }
            case R_SPARC_DISP8: {
                newValue = symbolValue + addend - pc;
                mask = 255;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_DISP16: {
                newValue = symbolValue + addend - pc;
                mask = 65535;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_DISP32: {
                newValue = symbolValue + addend - pc;
                memory.setInt(relocationAddress, (int)newValue);
                break;
            }
            case R_SPARC_WDISP30: {
                newValue = symbolValue + addend - pc >>> 2;
                mask = 0x3FFFFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_WDISP22: {
                newValue = symbolValue + addend - pc >>> 2;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_HI22: {
                newValue = symbolValue + addend >>> 10;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_22: {
                newValue = symbolValue + addend;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_13: {
                newValue = symbolValue + addend;
                mask = 8191;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_LO10: {
                newValue = symbolValue + addend;
                mask = 1023;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_PC10: {
                newValue = symbolValue + addend - pc;
                mask = 1023;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_PC22: {
                newValue = symbolValue + addend - pc >> 10;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_JMP_SLOT: {
                int sparc_sethi_g1 = 0x3000000;
                int sparc_jmpl_g1_immed_o1 = -2118098944;
                int sparc_nop = 0x1000000;
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, (int)(0x3000000L | newValue >> 10));
                memory.setInt(relocationAddress.add(4L), (int)(0xFFFFFFFF81C06000L | newValue & 0x3FFL));
                memory.setInt(relocationAddress.add(8L), 0x1000000);
                break;
            }
            case R_SPARC_GLOB_DAT: {
                newValue = symbolValue;
                memory.setInt(relocationAddress, (int)newValue);
                break;
            }
            case R_SPARC_UA32: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, (int)newValue);
                break;
            }
            case R_SPARC_10: {
                newValue = symbolValue + addend;
                mask = 1023;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_11: {
                newValue = symbolValue + addend;
                mask = 2047;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_HH22: {
                newValue = symbolValue + addend >> 42;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_HM10: {
                newValue = symbolValue + addend >> 32;
                mask = 1023;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_LM22: {
                newValue = symbolValue + addend >>> 10;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_PC_HH22: {
                newValue = symbolValue + addend - pc >> 42;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_PC_HM10: {
                newValue = symbolValue + addend - pc >> 32;
                mask = 1023;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_PC_LM22: {
                newValue = symbolValue + addend - pc >> 10;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_WDISP16: {
                newValue = symbolValue + addend - pc >>> 2;
                newValue = (newValue & 0xC000L) << 6 | newValue & 0x3FFFL;
                memory.setInt(relocationAddress, (oldValue &= 0x303FFF) | (int)newValue);
                break;
            }
            case R_SPARC_WDISP19: {
                newValue = symbolValue + addend - pc >>> 2;
                mask = 524287;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_7: {
                newValue = symbolValue + addend;
                mask = 127;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_5: {
                newValue = symbolValue + addend;
                mask = 31;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_6: {
                newValue = symbolValue + addend;
                mask = 63;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_HIX22: {
                newValue = (symbolValue + addend ^ 0xFFFFFFFFFFFFFFFFL) >> 10;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_LOX10: {
                newValue = symbolValue + addend & 0x3FFL | 0x1C00L;
                mask = 8191;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_H44: {
                newValue = symbolValue + addend >> 22;
                mask = 0x3FFFFF;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_M44: {
                newValue = symbolValue + addend >> 12;
                mask = 1023;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_L44: {
                newValue = symbolValue + addend;
                mask = 4095;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            case R_SPARC_UA16: {
                newValue = symbolValue + addend;
                mask = 65535;
                memory.setInt(relocationAddress, (oldValue &= ~mask) | (int)(newValue &= (long)mask));
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

