/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph.attributes;

import ghidra.util.datastruct.LongIntHashtable;
import ghidra.util.exception.NoValueException;
import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.attributes.Attribute;
import java.util.Arrays;
import java.util.Comparator;

public class IntegerAttribute<T extends KeyedObject>
extends Attribute<T> {
    private LongIntHashtable values;
    private static String attributeType = "INTEGER_TYPE";

    public IntegerAttribute(String name, KeyIndexableSet<T> set) {
        super(name, set);
        this.values = new LongIntHashtable(set.size());
    }

    public void setValue(T o, int value) {
        this.update();
        this.values.put(o.key(), value);
    }

    public int getValue(KeyedObject o) throws NoValueException {
        return this.values.get(o.key());
    }

    public KeyedObject[] toSortedArray() {
        KeyedObject[] keyedObjects = this.owningSet().toArray();
        Arrays.sort(keyedObjects, new IntegerComparator());
        return keyedObjects;
    }

    public KeyedObject[] toSortedArray(KeyedObject[] keyedObjects) {
        KeyedObject[] clone = (KeyedObject[])keyedObjects.clone();
        Arrays.sort(clone, new IntegerComparator());
        return clone;
    }

    @Override
    public String attributeType() {
        return attributeType;
    }

    @Override
    public void clear() {
        this.values.removeAll();
    }

    @Override
    public String getValueAsString(KeyedObject o) {
        try {
            return Integer.toString(this.getValue(o));
        }
        catch (NoValueException exc) {
            return "0";
        }
    }

    class IntegerComparator
    implements Comparator<KeyedObject> {
        IntegerComparator() {
        }

        @Override
        public int compare(KeyedObject object1, KeyedObject object2) {
            KeyedObject ko1 = object1;
            KeyedObject ko2 = object2;
            int value1 = 0;
            int value2 = 0;
            value1 = IntegerAttribute.this.getValue(ko1);
            try {
                value2 = IntegerAttribute.this.getValue(ko2);
                if (value1 - value2 != 0) {
                    return value1 - value2;
                }
                if (ko1.key() - ko2.key() < 0L) {
                    return -1;
                }
                if (ko1.key() - ko2.key() > 0L) {
                    return 1;
                }
                return 0;
            }
            catch (NoValueException exc2) {
                try {
                    return -1;
                }
                catch (NoValueException exc) {
                    try {
                        value2 = IntegerAttribute.this.getValue(ko2);
                        return 1;
                    }
                    catch (NoValueException exc22) {
                        if (ko1.key() - ko2.key() < 0L) {
                            return -1;
                        }
                        if (ko1.key() - ko2.key() > 0L) {
                            return 1;
                        }
                        return 0;
                    }
                }
            }
        }
    }
}

