/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import java.util.Set;
import javax.lang.model.element.Modifier;

public enum AccessSpec {
    PRIVATE(0),
    PACKAGE(1),
    PROTECTED(2),
    PUBLIC(3);

    private final int level;

    private AccessSpec(int level) {
        this.level = level;
    }

    public static boolean isSameOrMorePermissive(AccessSpec first, AccessSpec second) {
        return first.level <= second.level;
    }

    public static AccessSpec get(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return PRIVATE;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return PROTECTED;
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return PUBLIC;
        }
        return PACKAGE;
    }
}

