/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

public class MethodProtector {
    private boolean inUse;

    public <E extends Throwable> void take(TemperamentalCallable<E> callable) throws E {
        if (this.inUse) {
            return;
        }
        try {
            this.inUse = true;
            callable.run();
        }
        finally {
            this.inUse = false;
        }
    }

    public <E extends Throwable> void avoid(TemperamentalCallable<E> callable) throws E {
        if (this.inUse) {
            return;
        }
        callable.run();
    }

    public static interface TemperamentalCallable<E extends Throwable> {
        public void run() throws E;
    }
}

