/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.PreviewDataTableCellRenderer;
import ghidra.util.table.PreviewTableCellData;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class PreviewTableColumn
extends ProgramLocationTableColumnExtensionPoint<ProgramLocation, PreviewTableCellData> {
    private CodeUnitFormat codeUnitFormat;
    private PreviewDataTableCellRenderer previewRenderer = new PreviewDataTableCellRenderer();

    public String getColumnName() {
        return "Preview";
    }

    public PreviewTableCellData getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        ProgramLocation loc = rowObject;
        return new PreviewTableCellData(loc, this.getCodeUnitFormat(serviceProvider));
    }

    private CodeUnitFormat getCodeUnitFormat(ServiceProvider serviceProvider) {
        if (this.codeUnitFormat == null) {
            this.codeUnitFormat = new BrowserCodeUnitFormat(serviceProvider);
        }
        return this.codeUnitFormat;
    }

    @Override
    public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        return rowObject;
    }

    public GColumnRenderer<PreviewTableCellData> getColumnRenderer() {
        return this.previewRenderer;
    }
}

